/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.sf.marineapi.ais.message.AISMessage;
import net.sf.marineapi.ais.parser.AISMessage01Parser;
import net.sf.marineapi.ais.parser.AISMessage02Parser;
import net.sf.marineapi.ais.parser.AISMessage03Parser;
import net.sf.marineapi.ais.parser.AISMessage04Parser;
import net.sf.marineapi.ais.parser.AISMessage05Parser;
import net.sf.marineapi.ais.parser.AISMessage09Parser;
import net.sf.marineapi.ais.parser.AISMessage18Parser;
import net.sf.marineapi.ais.parser.AISMessage19Parser;
import net.sf.marineapi.ais.parser.AISMessage21Parser;
import net.sf.marineapi.ais.parser.AISMessage24Parser;
import net.sf.marineapi.ais.parser.AISMessageParser;
import net.sf.marineapi.ais.parser.AisMessage27Parser;
import net.sf.marineapi.ais.util.Sixbit;
import net.sf.marineapi.nmea.sentence.AISSentence;

public class AISMessageFactory {
    private static AISMessageFactory instance;
    private Map<Integer, Class<? extends AISMessage>> parsers = new HashMap<Integer, Class<? extends AISMessage>>(7);

    private AISMessageFactory() {
        this.parsers.put(1, AISMessage01Parser.class);
        this.parsers.put(2, AISMessage02Parser.class);
        this.parsers.put(3, AISMessage03Parser.class);
        this.parsers.put(4, AISMessage04Parser.class);
        this.parsers.put(5, AISMessage05Parser.class);
        this.parsers.put(9, AISMessage09Parser.class);
        this.parsers.put(18, AISMessage18Parser.class);
        this.parsers.put(19, AISMessage19Parser.class);
        this.parsers.put(21, AISMessage21Parser.class);
        this.parsers.put(24, AISMessage24Parser.class);
        this.parsers.put(27, AisMessage27Parser.class);
    }

    public AISMessage create(AISSentence ... sentences) {
        AISMessage result;
        AISMessageParser parser = new AISMessageParser(sentences);
        if (!this.parsers.containsKey(parser.getMessageType())) {
            String msg = String.format("no parser for message type %d", parser.getMessageType());
            throw new IllegalArgumentException(msg);
        }
        Class<? extends AISMessage> c = this.parsers.get(parser.getMessageType());
        try {
            Constructor<? extends AISMessage> co = c.getConstructor(Sixbit.class);
            result = co.newInstance(parser.getSixbit());
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getCause());
        }
        return result;
    }

    public static AISMessageFactory getInstance() {
        if (instance == null) {
            instance = new AISMessageFactory();
        }
        return instance;
    }
}

