/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import net.sf.marineapi.ais.message.AISPositionReport;
import net.sf.marineapi.ais.parser.AISMessageParser;
import net.sf.marineapi.ais.util.AISRuleViolation;
import net.sf.marineapi.ais.util.Angle12;
import net.sf.marineapi.ais.util.Angle9;
import net.sf.marineapi.ais.util.Latitude27;
import net.sf.marineapi.ais.util.Longitude28;
import net.sf.marineapi.ais.util.ManeuverIndicator;
import net.sf.marineapi.ais.util.NavigationalStatus;
import net.sf.marineapi.ais.util.RateOfTurn;
import net.sf.marineapi.ais.util.Sixbit;
import net.sf.marineapi.ais.util.SpeedOverGround;
import net.sf.marineapi.ais.util.TimeStamp;

class AISPositionReportParser
extends AISMessageParser
implements AISPositionReport {
    private static final String SEPARATOR = "\n\t";
    private static final int NAVIGATIONALSTATUS = 0;
    private static final int RATEOFTURN = 1;
    private static final int SPEEDOVERGROUND = 2;
    private static final int POSITIONACCURACY = 3;
    private static final int LONGITUDE = 4;
    private static final int LATITUDE = 5;
    private static final int COURSEOVERGROUND = 6;
    private static final int TRUEHEADING = 7;
    private static final int TIMESTAMP = 8;
    private static final int MANOEUVER = 9;
    private static final int[] FROM = new int[]{38, 42, 50, 60, 61, 89, 116, 128, 137, 143};
    private static final int[] TO = new int[]{42, 50, 60, 61, 89, 116, 128, 137, 143, 145};
    private int fNavigationalStatus;
    private int fRateOfTurn;
    private int fSOG;
    private boolean fPositionAccuracy;
    private int fLongitude;
    private int fLatitude;
    private int fCOG;
    private int fTrueHeading;
    private int fTimeStamp;
    private int fManouverIndicator;

    public AISPositionReportParser(Sixbit content) {
        super(content, 168, 204);
        this.fNavigationalStatus = content.getInt(FROM[0], TO[0]);
        if (!NavigationalStatus.isCorrect(this.fNavigationalStatus)) {
            this.addViolation(new AISRuleViolation("NavigationalStatus", this.fNavigationalStatus, "[0,8] + [14,15]"));
        }
        this.fRateOfTurn = content.getAs8BitInt(FROM[1], TO[1]);
        this.fSOG = content.getInt(FROM[2], TO[2]);
        this.fPositionAccuracy = content.getBoolean(TO[3]);
        this.fLongitude = content.getAs28BitInt(FROM[4], TO[4]);
        if (!Longitude28.isCorrect(this.fLongitude)) {
            this.addViolation(new AISRuleViolation("LongitudeInDegrees", this.fLongitude, "[-108000000,108000000] + {108600000}"));
        }
        this.fLatitude = content.getAs27BitInt(FROM[5], TO[5]);
        if (!Latitude27.isCorrect(this.fLatitude)) {
            this.addViolation(new AISRuleViolation("LatitudeInDegrees", this.fLatitude, "[-54000000,54000000] + {54600000}"));
        }
        this.fCOG = content.getInt(FROM[6], TO[6]);
        if (!Angle12.isCorrect(this.fCOG)) {
            this.addViolation(new AISRuleViolation("CourseOverGround", this.fCOG, "[0,3599] + {3600}"));
        }
        this.fTrueHeading = content.getInt(FROM[7], TO[7]);
        if (!Angle9.isCorrect(this.fTrueHeading)) {
            this.addViolation(new AISRuleViolation("TrueHeading", this.fTrueHeading, "[0,359] + {511}"));
        }
        this.fTimeStamp = content.getInt(FROM[8], TO[8]);
        this.fManouverIndicator = content.getInt(FROM[9], TO[9]);
        if (!ManeuverIndicator.isCorrect(this.fManouverIndicator)) {
            this.addViolation(new AISRuleViolation("ManouverIndicator", this.fManouverIndicator, "[1,2] + {0}"));
        }
    }

    @Override
    public int getNavigationalStatus() {
        return this.fNavigationalStatus;
    }

    @Override
    public double getRateOfTurn() {
        return RateOfTurn.toDegreesPerMinute(this.fRateOfTurn);
    }

    @Override
    public double getSpeedOverGround() {
        return SpeedOverGround.toKnots(this.fSOG);
    }

    @Override
    public boolean isAccurate() {
        return this.fPositionAccuracy;
    }

    @Override
    public double getLongitudeInDegrees() {
        return Longitude28.toDegrees(this.fLongitude);
    }

    @Override
    public double getLatitudeInDegrees() {
        return Latitude27.toDegrees(this.fLatitude);
    }

    @Override
    public double getCourseOverGround() {
        return Angle12.toDegrees(this.fCOG);
    }

    @Override
    public int getTrueHeading() {
        return this.fTrueHeading;
    }

    @Override
    public int getTimeStamp() {
        return this.fTimeStamp;
    }

    @Override
    public int getManouverIndicator() {
        return this.fManouverIndicator;
    }

    @Override
    public boolean hasRateOfTurn() {
        return RateOfTurn.isTurnIndicatorAvailable(this.fRateOfTurn);
    }

    @Override
    public boolean hasSpeedOverGround() {
        return SpeedOverGround.isAvailable(this.fSOG);
    }

    @Override
    public boolean hasCourseOverGround() {
        return Angle12.isAvailable(this.fCOG);
    }

    @Override
    public boolean hasTrueHeading() {
        return Angle9.isAvailable(this.fTrueHeading);
    }

    @Override
    public boolean hasTimeStamp() {
        return TimeStamp.isAvailable(this.fTimeStamp);
    }

    @Override
    public boolean hasLongitude() {
        return Longitude28.isAvailable(this.fLongitude);
    }

    @Override
    public boolean hasLatitude() {
        return Latitude27.isAvailable(this.fLatitude);
    }

    public String toString() {
        String result = "\tNav st:  " + NavigationalStatus.toString(this.fNavigationalStatus);
        result = result + "\n\tROT:     " + RateOfTurn.toString(this.fRateOfTurn);
        result = result + "\n\tSOG:     " + SpeedOverGround.toString(this.fSOG);
        result = result + "\n\tPos acc: " + (this.fPositionAccuracy ? "high" : "low") + " accuracy";
        result = result + "\n\tLon:     " + Longitude28.toString(this.fLongitude);
        result = result + "\n\tLat:     " + Latitude27.toString(this.fLatitude);
        result = result + "\n\tCOG:     " + Angle12.toString(this.fCOG);
        result = result + "\n\tHeading: " + Angle9.getTrueHeadingString(this.fTrueHeading);
        result = result + "\n\tTime:    " + TimeStamp.toString(this.fTimeStamp);
        result = result + "\n\tMan ind: " + ManeuverIndicator.toString(this.fManouverIndicator);
        return result;
    }
}

