/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import net.sf.marineapi.ais.message.AISUTCReport;
import net.sf.marineapi.ais.parser.AISMessageParser;
import net.sf.marineapi.ais.util.AISRuleViolation;
import net.sf.marineapi.ais.util.Latitude27;
import net.sf.marineapi.ais.util.Longitude28;
import net.sf.marineapi.ais.util.PositioningDevice;
import net.sf.marineapi.ais.util.Sixbit;

class AISUTCParser
extends AISMessageParser
implements AISUTCReport {
    private static final String SEPARATOR = "\n\t";
    private static final int UTC_YEAR = 0;
    private static final int UTC_MONTH = 1;
    private static final int UTC_DAY = 2;
    private static final int UTC_HOUR = 3;
    private static final int UTC_MINUTE = 4;
    private static final int UTC_SECOND = 5;
    private static final int POSITIONACCURACY = 6;
    private static final int LONGITUDE = 7;
    private static final int LATITUDE = 8;
    private static final int FIXING_DEV_TYPE = 9;
    private static final int[] FROM = new int[]{38, 52, 56, 61, 66, 72, 78, 79, 107, 134};
    private static final int[] TO = new int[]{52, 56, 61, 66, 72, 78, 79, 107, 134, 138};
    private int fUTCYear;
    private int fUTCMonth;
    private int fUTCDay;
    private int fUTCHour;
    private int fUTCMinute;
    private int fUTCSecond;
    private boolean fPositionAccuracy;
    private int fLongitude;
    private int fLatitude;
    private int fTypeOfEPFD;

    public AISUTCParser(Sixbit content) {
        super(content, 168);
        this.fUTCYear = content.getInt(FROM[0], TO[0]);
        this.fUTCMonth = content.getInt(FROM[1], TO[1]);
        this.fUTCDay = content.getInt(FROM[2], TO[2]);
        this.fUTCHour = content.getInt(FROM[3], TO[3]);
        this.fUTCMinute = content.getInt(FROM[4], TO[4]);
        this.fUTCSecond = content.getInt(FROM[5], TO[5]);
        this.fPositionAccuracy = content.getBoolean(FROM[6]);
        this.fLongitude = content.getAs28BitInt(FROM[7], TO[7]);
        if (!Longitude28.isCorrect(this.fLongitude)) {
            this.addViolation(new AISRuleViolation("LongitudeInDegrees", this.fLongitude, "[-108000000,108000000] + {108600000}"));
        }
        this.fLatitude = content.getAs27BitInt(FROM[8], TO[8]);
        if (!Latitude27.isCorrect(this.fLatitude)) {
            this.addViolation(new AISRuleViolation("LatitudeInDegrees", this.fLatitude, "[-54000000,54000000] + {54600000}"));
        }
        this.fTypeOfEPFD = content.getInt(FROM[9], TO[9]);
    }

    @Override
    public int getUtcYear() {
        return this.fUTCYear;
    }

    @Override
    public int getUtcMonth() {
        return this.fUTCMonth;
    }

    @Override
    public int getUtcDay() {
        return this.fUTCDay;
    }

    @Override
    public int getUtcHour() {
        return this.fUTCHour;
    }

    @Override
    public int getUtcMinute() {
        return this.fUTCMinute;
    }

    @Override
    public int getUtcSecond() {
        return this.fUTCSecond;
    }

    public boolean isAccurate() {
        return this.fPositionAccuracy;
    }

    public double getLongitudeInDegrees() {
        return Longitude28.toDegrees(this.fLongitude);
    }

    public double getLatitudeInDegrees() {
        return Latitude27.toDegrees(this.fLatitude);
    }

    @Override
    public int getTypeOfEPFD() {
        return this.fTypeOfEPFD;
    }

    public boolean hasLongitude() {
        return Longitude28.isAvailable(this.fLongitude);
    }

    public boolean hasLatitude() {
        return Latitude27.isAvailable(this.fLatitude);
    }

    public String toString() {
        String result = "\tYear:    " + this.getUtcYear();
        result = result + "\n\tMonth:   " + this.getUtcMonth();
        result = result + "\n\tDay:     " + this.getUtcDay();
        result = result + "\n\tHour:    " + this.getUtcHour();
        result = result + "\n\tMinute:  " + this.getUtcMinute();
        result = result + "\n\tSec:     " + this.getUtcSecond();
        result = result + "\n\tPos acc: " + (this.fPositionAccuracy ? "high" : "low") + " accuracy";
        result = result + "\n\tLon:     " + Longitude28.toString(this.fLongitude);
        result = result + "\n\tLat:     " + Latitude27.toString(this.fLatitude);
        result = result + "\n\tEPFD:    " + PositioningDevice.toString(this.fTypeOfEPFD);
        return result;
    }
}

