/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.util;

import java.text.DecimalFormat;

public class Latitude17 {
    private static final DecimalFormat COORD_FORMAT = new DecimalFormat("##0.000000;-##0.000000");
    private static final int MINUTE_PART_MULTIPLIER = 600;
    private static final int MIN_VALUE = -54000;
    private static final int MAX_VALUE = 54000;
    private static final int DEFAULT_VALUE = 54600;
    public static final String RANGE = "[-54000,54000] + {54600}";

    public static double toDegrees(int value) {
        return (double)value / 600.0;
    }

    public static boolean isAvailable(int value) {
        return value >= -54000 && value <= 54000;
    }

    public static boolean isCorrect(int value) {
        return Latitude17.isAvailable(value) || value == 54600;
    }

    public static String toString(int value) {
        if (!Latitude17.isCorrect(value)) {
            return "invalid latitude";
        }
        if (!Latitude17.isAvailable(value)) {
            return "latitude not available";
        }
        return COORD_FORMAT.format(Latitude17.toDegrees(value));
    }
}

