/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.util;

import java.text.DecimalFormat;

public class Longitude18 {
    private static final DecimalFormat COORD_FORMAT = new DecimalFormat("##0.000000;-##0.000000");
    private static final int MINUTE_PART_MULTIPLIER = 600;
    private static final int MIN_VALUE = -108000;
    private static final int MAX_VALUE = 108000;
    private static final int DEFAULT_VALUE = 108600;
    public static final String RANGE = "[-108000,108000] + {108600}";

    public static double toDegrees(int value) {
        return (double)value / 600.0;
    }

    public static boolean isAvailable(int value) {
        return value >= -108000 && value <= 108000;
    }

    public static boolean isCorrect(int value) {
        return Longitude18.isAvailable(value) || value == 108600;
    }

    public static String toString(int value) {
        if (!Longitude18.isCorrect(value)) {
            return "invalid longitude";
        }
        if (!Longitude18.isAvailable(value)) {
            return "longitude not available";
        }
        return COORD_FORMAT.format(Longitude18.toDegrees(value));
    }
}

