/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.sf.marineapi.nmea.io.ExceptionListener;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.provider.PositionProvider;
import net.sf.marineapi.provider.event.PositionEvent;
import net.sf.marineapi.provider.event.PositionListener;

public class PositionProviderExample
implements PositionListener,
ExceptionListener {
    PositionProvider provider;

    public PositionProviderExample(File f) throws FileNotFoundException {
        FileInputStream stream = new FileInputStream(f);
        SentenceReader reader = new SentenceReader(stream);
        reader.setExceptionListener(this);
        this.provider = new PositionProvider(reader);
        this.provider.addListener(this);
        reader.start();
    }

    @Override
    public void providerUpdate(PositionEvent evt) {
        System.out.println("TPV: " + evt.toString());
    }

    @Override
    public void onException(Exception e) {
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage:\njava PositionProviderExample nmea.log");
            System.exit(1);
        }
        try {
            new PositionProviderExample(new File(args[0]));
            System.out.println("Running, press CTRL-C to stop..");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

