/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.example;

import gnu.io.CommPortIdentifier;
import gnu.io.RXTXPort;
import gnu.io.SerialPort;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import net.sf.marineapi.nmea.event.SentenceEvent;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.sentence.SentenceValidator;

public class SerialPortExample
implements SentenceListener {
    public SerialPortExample() {
        this.init();
    }

    @Override
    public void readingPaused() {
        System.out.println("-- Paused --");
    }

    @Override
    public void readingStarted() {
        System.out.println("-- Started --");
    }

    @Override
    public void readingStopped() {
        System.out.println("-- Stopped --");
    }

    @Override
    public void sentenceRead(SentenceEvent event) {
        System.out.println(event.getSentence());
    }

    private SerialPort getSerialPort() {
        try {
            Enumeration e = CommPortIdentifier.getPortIdentifiers();
            while (e.hasMoreElements()) {
                CommPortIdentifier id = (CommPortIdentifier)e.nextElement();
                if (id.getPortType() != 1) continue;
                RXTXPort sp = id.open("SerialExample", 30);
                sp.setSerialPortParams(4800, 8, 1, 0);
                sp.enableReceiveTimeout(1000);
                sp.enableReceiveThreshold(0);
                InputStream is = sp.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader buf = new BufferedReader(isr);
                System.out.println("Scanning port " + sp.getName());
                for (int i = 0; i < 5; ++i) {
                    try {
                        String data = buf.readLine();
                        if (!SentenceValidator.isValid(data)) continue;
                        System.out.println("NMEA data found!");
                        return sp;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                is.close();
                isr.close();
                buf.close();
            }
            System.out.println("NMEA data was not found..");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void init() {
        try {
            SerialPort sp = this.getSerialPort();
            if (sp != null) {
                InputStream is = sp.getInputStream();
                SentenceReader sr = new SentenceReader(is);
                sr.addSentenceListener(this);
                sr.start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new SerialPortExample();
    }
}

