/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.event;

import net.sf.marineapi.nmea.event.SentenceEvent;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.util.GenericTypeResolver;

public abstract class AbstractSentenceListener<T extends Sentence>
implements SentenceListener {
    final Class<?> sentenceType;

    public AbstractSentenceListener() {
        this.sentenceType = GenericTypeResolver.resolve(this.getClass(), AbstractSentenceListener.class);
    }

    protected AbstractSentenceListener(Class<T> c) {
        this.sentenceType = c;
    }

    @Override
    public final void sentenceRead(SentenceEvent event) {
        Sentence sentence = event.getSentence();
        if (this.sentenceType.isAssignableFrom(sentence.getClass())) {
            this.sentenceRead(sentence);
        }
    }

    public abstract void sentenceRead(T var1);

    @Override
    public void readingPaused() {
    }

    @Override
    public void readingStarted() {
    }

    @Override
    public void readingStopped() {
    }
}

