/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.util.ArrayList;
import java.util.List;
import net.sf.marineapi.nmea.parser.DataNotAvailableException;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.GSVSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.SatelliteInfo;

class GSVParser
extends SentenceParser
implements GSVSentence {
    private static final int NUMBER_OF_SENTENCES = 0;
    private static final int SENTENCE_NUMBER = 1;
    private static final int SATELLITES_IN_VIEW = 2;
    private static final int[] ID_FIELDS = new int[]{3, 7, 11, 15};
    private static final int ELEVATION = 1;
    private static final int AZIMUTH = 2;
    private static final int NOISE = 3;

    public GSVParser(String nmea) {
        super(nmea, SentenceId.GSV);
    }

    public GSVParser(TalkerId talker) {
        super(talker, SentenceId.GSV, 19);
    }

    @Override
    public int getSatelliteCount() {
        return this.getIntValue(2);
    }

    @Override
    public List<SatelliteInfo> getSatelliteInfo() {
        ArrayList<SatelliteInfo> satellites = new ArrayList<SatelliteInfo>(4);
        for (int idf : ID_FIELDS) {
            try {
                String id = this.getStringValue(idf);
                int elev = this.getIntValue(idf + 1);
                int azm = this.getIntValue(idf + 2);
                int snr = 0;
                try {
                    snr = this.getIntValue(idf + 3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                satellites.add(new SatelliteInfo(id, elev, azm, snr));
            }
            catch (DataNotAvailableException id) {
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
        }
        return satellites;
    }

    @Override
    public int getSentenceCount() {
        return this.getIntValue(0);
    }

    @Override
    public int getSentenceIndex() {
        return this.getIntValue(1);
    }

    @Override
    public boolean isFirst() {
        return this.getSentenceIndex() == 1;
    }

    @Override
    public boolean isLast() {
        return this.getSentenceIndex() == this.getSentenceCount();
    }

    @Override
    public void setSatelliteCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Satellite count cannot be negative");
        }
        this.setIntValue(2, count);
    }

    @Override
    public void setSatelliteInfo(List<SatelliteInfo> info) {
        if (info.size() > 4) {
            throw new IllegalArgumentException("Maximum list size is 4");
        }
        int i = 0;
        for (int id : ID_FIELDS) {
            if (i < info.size()) {
                SatelliteInfo si = info.get(i++);
                this.setStringValue(id, si.getId());
                this.setIntValue(id + 1, si.getElevation());
                this.setIntValue(id + 2, si.getAzimuth(), 3);
                this.setIntValue(id + 3, si.getNoise());
                continue;
            }
            this.setStringValue(id, "");
            this.setStringValue(id + 1, "");
            this.setStringValue(id + 2, "");
            this.setStringValue(id + 3, "");
        }
    }

    @Override
    public void setSentenceCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("Number of sentences cannot be negative");
        }
        this.setIntValue(0, count);
    }

    @Override
    public void setSentenceIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Sentence index cannot be negative");
        }
        this.setIntValue(1, index);
    }
}

