/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.HTCSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.DataStatus;
import net.sf.marineapi.nmea.util.Direction;
import net.sf.marineapi.nmea.util.SteeringMode;
import net.sf.marineapi.nmea.util.TurnMode;

class HTCParser
extends SentenceParser
implements HTCSentence {
    private static final int OVERRIDE = 0;
    private static final int COMMANDED_RUDDER_ANGLE = 1;
    private static final int COMMANDED_RUDDER_DIRECTION = 2;
    private static final int SELECTED_STEERING_MODE = 3;
    private static final int TURN_MODE = 4;
    private static final int COMMANDED_RUDDER_LIMIT = 5;
    private static final int COMMANDED_OFF_HEADING_LIMIT = 6;
    private static final int COMMANDED_RADIUS_OF_TURN_FOR_HEADING_CHANGES = 7;
    private static final int COMMANDED_RATE_OF_TURN_FOR_HEADING_CHANGES = 8;
    private static final int COMMANDED_HEADING_TO_STEER = 9;
    private static final int COMMANDED_OFF_TRACK_LIMIT = 10;
    private static final int COMMANDED_TRACK = 11;
    private static final int HEADING_REFERENCE_IN_USE = 12;

    public HTCParser(String nmea) {
        super(nmea, SentenceId.HTC);
    }

    public HTCParser(TalkerId talker) {
        super(talker, SentenceId.HTC, 13);
    }

    HTCParser(String nmea, SentenceId type) {
        super(nmea, type);
    }

    HTCParser(TalkerId tid, SentenceId sid, int size) {
        super(tid, sid, size);
    }

    @Override
    public DataStatus getOverride() {
        if (this.hasValue(0)) {
            return DataStatus.valueOf(this.getCharValue(0));
        }
        return null;
    }

    @Override
    public double getRudderAngle() {
        if (this.hasValue(1)) {
            return this.getDoubleValue(1);
        }
        return Double.NaN;
    }

    @Override
    public Direction getRudderDirection() {
        if (this.hasValue(2)) {
            return Direction.valueOf(this.getCharValue(2));
        }
        return null;
    }

    @Override
    public SteeringMode getSteeringMode() {
        if (this.hasValue(3)) {
            return SteeringMode.valueOf(this.getCharValue(3));
        }
        return null;
    }

    @Override
    public TurnMode getTurnMode() {
        if (this.hasValue(4)) {
            return TurnMode.valueOf(this.getCharValue(4));
        }
        return null;
    }

    @Override
    public double getRudderLimit() {
        if (this.hasValue(5)) {
            return this.getDoubleValue(5);
        }
        return Double.NaN;
    }

    @Override
    public double getOffHeadingLimit() {
        if (this.hasValue(6)) {
            return this.getDoubleValue(6);
        }
        return Double.NaN;
    }

    @Override
    public double getRadiusOfTurn() {
        if (this.hasValue(7)) {
            return this.getDoubleValue(7);
        }
        return Double.NaN;
    }

    @Override
    public double getRateOfTurn() {
        if (this.hasValue(8)) {
            return this.getDoubleValue(8);
        }
        return Double.NaN;
    }

    @Override
    public double getHeadingToSteer() {
        if (this.hasValue(9)) {
            return this.getDoubleValue(9);
        }
        return Double.NaN;
    }

    @Override
    public double getOffTrackLimit() {
        if (this.hasValue(10)) {
            return this.getDoubleValue(10);
        }
        return Double.NaN;
    }

    @Override
    public double getTrack() {
        if (this.hasValue(11)) {
            return this.getDoubleValue(11);
        }
        return Double.NaN;
    }

    @Override
    public boolean isHeadingTrue() {
        return this.hasValue(12) && this.getCharValue(12) == 'T';
    }
}

