/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.util.Arrays;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.OSDSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.DataStatus;
import net.sf.marineapi.nmea.util.ReferenceSystem;
import net.sf.marineapi.nmea.util.Units;

class OSDParser
extends SentenceParser
implements OSDSentence {
    private static final int HEADING = 0;
    private static final int HEADING_STATUS = 1;
    private static final int COURSE = 2;
    private static final int COURSE_REFERENCE = 3;
    private static final int SPEED = 4;
    private static final int SPEED_REFERENCE = 5;
    private static final int VESSEL_SET = 6;
    private static final int VESSEL_DRIFT = 7;
    private static final int SPEED_UNITS = 8;
    private static final Units[] VALID_SPEED_UNITS = new Units[]{Units.KILOMETERS, Units.NAUTICAL_MILES, Units.STATUTE_MILES};

    public OSDParser(String nmea) {
        super(nmea, SentenceId.OSD);
    }

    public OSDParser(TalkerId talker) {
        super(talker, SentenceId.OSD, 9);
    }

    @Override
    public double getHeading() {
        return this.getDoubleValue(0);
    }

    @Override
    public DataStatus getHeadingStatus() {
        return DataStatus.valueOf(this.getCharValue(1));
    }

    @Override
    public double getCourse() {
        return this.getDoubleValue(2);
    }

    @Override
    public ReferenceSystem getCourseReference() {
        return ReferenceSystem.valueOf(this.getCharValue(3));
    }

    @Override
    public double getSpeed() {
        return this.getDoubleValue(4);
    }

    @Override
    public ReferenceSystem getSpeedReference() {
        return ReferenceSystem.valueOf(this.getCharValue(5));
    }

    @Override
    public double getVesselSet() {
        return this.getDoubleValue(6);
    }

    @Override
    public double getVesselDrift() {
        return this.getDoubleValue(7);
    }

    @Override
    public Units getSpeedUnits() {
        return Units.valueOf(this.getCharValue(8));
    }

    @Override
    public void setHeading(double heading) {
        this.setDoubleValue(0, heading);
    }

    @Override
    public void setHeadingStatus(DataStatus status) {
        this.setCharValue(1, status.toChar());
    }

    @Override
    public void setCourse(double course) {
        this.setDoubleValue(2, course);
    }

    @Override
    public void setCourseReference(ReferenceSystem reference) {
        this.setCharValue(3, reference.toChar());
    }

    @Override
    public void setSpeed(double speed) {
        this.setDoubleValue(4, speed);
    }

    @Override
    public void setSpeedReference(ReferenceSystem reference) {
        this.setCharValue(5, reference.toChar());
    }

    @Override
    public void setVesselSet(double set) {
        this.setDoubleValue(6, set);
    }

    @Override
    public void setVesselDrift(double drift) {
        this.setDoubleValue(7, drift);
    }

    @Override
    public void setSpeedUnits(Units units) {
        if (!Arrays.asList(VALID_SPEED_UNITS).contains((Object)units)) {
            String err = "Speed units must be ";
            for (int i = 0; i < VALID_SPEED_UNITS.length; ++i) {
                Units u = VALID_SPEED_UNITS[i];
                err = err + u.name() + "(" + u.toChar() + ")";
                if (i == VALID_SPEED_UNITS.length - 1) continue;
                err = err + ", ";
            }
            throw new IllegalArgumentException(err);
        }
        this.setCharValue(8, units.toChar());
    }
}

