/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.sf.marineapi.nmea.parser.ParseException;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.CompassPoint;
import net.sf.marineapi.nmea.util.Position;

public abstract class PositionParser
extends SentenceParser {
    protected PositionParser(String nmea, SentenceId type) {
        super(nmea, type);
    }

    protected PositionParser(TalkerId talker, SentenceId type, int size) {
        super(talker, type, size);
    }

    protected CompassPoint parseHemisphereLat(int index) {
        char ch = this.getCharValue(index);
        return PositionParser.parseHemisphereLat(ch);
    }

    protected CompassPoint parseHemisphereLon(int index) {
        char ch = this.getCharValue(index);
        return PositionParser.parseHemisphereLon(ch);
    }

    protected double parseDegrees(int index) {
        String field = this.getStringValue(index);
        return PositionParser.parseDegrees(field);
    }

    protected Position parsePosition(int latIndex, int latHemIndex, int lonIndex, int lonHemIndex) {
        String latitudeValue = this.getStringValue(latIndex);
        char latitudeHemisphereIndicator = this.getCharValue(latHemIndex);
        String longitudeValue = this.getStringValue(lonIndex);
        char longitudeHemisphereIndicator = this.getCharValue(lonHemIndex);
        return PositionParser.parsePosition(latitudeValue, latitudeHemisphereIndicator, longitudeValue, longitudeHemisphereIndicator);
    }

    protected void setLatHemisphere(int field, CompassPoint hem) {
        if (hem != CompassPoint.NORTH && hem != CompassPoint.SOUTH) {
            throw new IllegalArgumentException("Invalid latitude hemisphere: " + (Object)((Object)hem));
        }
        this.setCharValue(field, hem.toChar());
    }

    protected void setLatitude(int index, double lat) {
        int deg = (int)Math.floor(lat);
        double min = (lat - (double)deg) * 60.0;
        DecimalFormat df = new DecimalFormat("00.000");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        String result = String.format("%02d%s", deg, df.format(min));
        this.setStringValue(index, result);
    }

    protected void setLongitude(int index, double lon) {
        int deg = (int)Math.floor(lon);
        double min = (lon - (double)deg) * 60.0;
        DecimalFormat nf = new DecimalFormat("00.000");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        nf.setDecimalFormatSymbols(dfs);
        String result = String.format("%03d%s", deg, nf.format(min));
        this.setStringValue(index, result);
    }

    protected void setLonHemisphere(int field, CompassPoint hem) {
        if (hem != CompassPoint.EAST && hem != CompassPoint.WEST) {
            throw new IllegalArgumentException("Invalid longitude hemisphere: " + (Object)((Object)hem));
        }
        this.setCharValue(field, hem.toChar());
    }

    protected void setPositionValues(Position p, int latIndex, int latHemIndex, int lonIndex, int lonHemIndex) {
        this.setLatitude(latIndex, Math.abs(p.getLatitude()));
        this.setLongitude(lonIndex, Math.abs(p.getLongitude()));
        this.setLatHemisphere(latHemIndex, p.getLatitudeHemisphere());
        this.setLonHemisphere(lonHemIndex, p.getLongitudeHemisphere());
    }

    public static double parseDegrees(String degreeStr) {
        int dotIndex = degreeStr.indexOf(".");
        String degStr = dotIndex > 2 ? degreeStr.substring(0, dotIndex - 2) : "0";
        String minStr = dotIndex > 2 ? degreeStr.substring(dotIndex - 2) : degreeStr;
        int deg = Integer.parseInt(degStr);
        double min = Double.parseDouble(minStr);
        return (double)deg + min / 60.0;
    }

    public static CompassPoint parseHemisphereLat(char ch) {
        CompassPoint d = CompassPoint.valueOf(ch);
        if (d != CompassPoint.NORTH && d != CompassPoint.SOUTH) {
            throw new ParseException("Invalid latitude hemisphere '" + ch + "'");
        }
        return d;
    }

    public static CompassPoint parseHemisphereLon(char ch) {
        CompassPoint d = CompassPoint.valueOf(ch);
        if (d != CompassPoint.EAST && d != CompassPoint.WEST) {
            throw new ParseException("Invalid longitude hemisphere " + ch + "'");
        }
        return d;
    }

    public static Position parsePosition(String latitudeValue, char latitudeHemisphereIndicator, String longitudeValue, char longitudeHemisphereIndicator) {
        double lat = PositionParser.parseDegrees(latitudeValue);
        double lon = PositionParser.parseDegrees(longitudeValue);
        CompassPoint lath = PositionParser.parseHemisphereLat(latitudeHemisphereIndicator);
        CompassPoint lonh = PositionParser.parseHemisphereLon(longitudeHemisphereIndicator);
        if (lath.equals((Object)CompassPoint.SOUTH)) {
            lat = -lat;
        }
        if (lonh.equals((Object)CompassPoint.WEST)) {
            lon = -lon;
        }
        return new Position(lat, lon);
    }
}

