/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.PositionParser;
import net.sf.marineapi.nmea.sentence.RMCSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.CompassPoint;
import net.sf.marineapi.nmea.util.DataStatus;
import net.sf.marineapi.nmea.util.Date;
import net.sf.marineapi.nmea.util.FaaMode;
import net.sf.marineapi.nmea.util.NavStatus;
import net.sf.marineapi.nmea.util.Position;
import net.sf.marineapi.nmea.util.Time;

class RMCParser
extends PositionParser
implements RMCSentence {
    private static final int UTC_TIME = 0;
    private static final int DATA_STATUS = 1;
    private static final int LATITUDE = 2;
    private static final int LAT_HEMISPHERE = 3;
    private static final int LONGITUDE = 4;
    private static final int LON_HEMISPHERE = 5;
    private static final int SPEED = 6;
    private static final int COURSE = 7;
    private static final int UTC_DATE = 8;
    private static final int MAG_VARIATION = 9;
    private static final int VAR_HEMISPHERE = 10;
    private static final int MODE = 11;
    private static final int NAV_STATUS = 12;

    public RMCParser(String nmea) {
        super(nmea, SentenceId.RMC);
    }

    public RMCParser(TalkerId talker) {
        super(talker, SentenceId.RMC, 13);
    }

    @Override
    public double getCorrectedCourse() {
        return this.getCourse() + this.getVariation();
    }

    @Override
    public double getCourse() {
        return this.getDoubleValue(7);
    }

    @Override
    public Date getDate() {
        return new Date(this.getStringValue(8));
    }

    @Override
    public CompassPoint getDirectionOfVariation() {
        return CompassPoint.valueOf(this.getCharValue(10));
    }

    @Override
    public FaaMode getMode() {
        return FaaMode.valueOf(this.getCharValue(11));
    }

    @Override
    public NavStatus getNavStatus() {
        return NavStatus.valueOf(this.getCharValue(12));
    }

    @Override
    public Position getPosition() {
        return this.parsePosition(2, 3, 4, 5);
    }

    @Override
    public double getSpeed() {
        return this.getDoubleValue(6);
    }

    @Override
    public DataStatus getStatus() {
        return DataStatus.valueOf(this.getCharValue(1));
    }

    @Override
    public Time getTime() {
        String str = this.getStringValue(0);
        return new Time(str);
    }

    @Override
    public double getVariation() {
        double variation = this.getDoubleValue(9);
        if (CompassPoint.EAST == this.getDirectionOfVariation() && variation > 0.0) {
            variation = -variation;
        }
        return variation;
    }

    @Override
    public void setCourse(double cog) {
        this.setDegreesValue(7, cog);
    }

    @Override
    public void setDate(Date date) {
        this.setStringValue(8, date.toString());
    }

    @Override
    public void setDirectionOfVariation(CompassPoint dir) {
        if (dir != CompassPoint.EAST && dir != CompassPoint.WEST) {
            throw new IllegalArgumentException("Invalid variation direction, expected EAST or WEST.");
        }
        this.setCharValue(10, dir.toChar());
    }

    @Override
    public void setMode(FaaMode mode) {
        this.setFieldCount(12);
        this.setCharValue(11, mode.toChar());
    }

    @Override
    public void setNavStatus(NavStatus navStatus) {
        this.setFieldCount(13);
        this.setCharValue(12, navStatus.toChar());
    }

    @Override
    public void setPosition(Position pos) {
        this.setPositionValues(pos, 2, 3, 4, 5);
    }

    @Override
    public void setSpeed(double sog) {
        this.setDoubleValue(6, sog, 1, 1);
    }

    @Override
    public void setStatus(DataStatus status) {
        this.setCharValue(1, status.toChar());
    }

    @Override
    public void setTime(Time t) {
        this.setStringValue(0, t.toString());
    }

    @Override
    public void setVariation(double var) {
        this.setDegreesValue(9, var);
    }
}

