/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.STALKSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;

class STALKParser
extends SentenceParser
implements STALKSentence {
    private static int COMMAND = 0;
    private static int FIRST_PARAM = 1;

    public STALKParser(String nmea) {
        super(nmea, SentenceId.ALK);
    }

    public STALKParser(TalkerId tid) {
        super(TalkerId.ST, SentenceId.ALK, 2);
        if (!tid.equals((Object)TalkerId.ST)) {
            throw new IllegalArgumentException("$STALK talker id 'ST' is mandatory (got " + (Object)((Object)tid) + ")");
        }
    }

    @Override
    public String getCommand() {
        return this.getStringValue(COMMAND);
    }

    @Override
    public void setCommand(String cmd) {
        this.setStringValue(COMMAND, cmd);
    }

    @Override
    public String[] getParameters() {
        return this.getStringValues(FIRST_PARAM);
    }

    @Override
    public void setParameters(String ... params) {
        this.setStringValues(FIRST_PARAM, params);
    }

    @Override
    public void addParameter(String param) {
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(this.getParameters()));
        params.add(param);
        this.setParameters(params.toArray(new String[params.size()]));
    }
}

