/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.DataNotAvailableException;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TLBSentence;
import net.sf.marineapi.nmea.sentence.TalkerId;

class TLBParser
extends SentenceParser
implements TLBSentence {
    private static final int FIRST_PAIR = 0;

    public TLBParser(String nmea) {
        super(nmea, SentenceId.TLB);
        if (this.getFieldCount() % 2 != 0) {
            throw new IllegalArgumentException("Invalid TLB sentence. Must contain pairs of target numbers and labels.");
        }
    }

    public TLBParser(TalkerId talker) {
        super(talker, SentenceId.TLB, 0);
    }

    @Override
    public int[] getTargetIds() {
        int[] ids = new int[this.getFieldCount() / 2];
        int i = 0;
        for (int j = 0; j < ids.length; ++j) {
            ids[j] = this.getIntValue(i);
            i += 2;
        }
        return ids;
    }

    @Override
    public String[] getTargetLabels() {
        String[] labels = new String[this.getFieldCount() / 2];
        int i = 1;
        for (int j = 0; j < labels.length; ++j) {
            try {
                labels[j] = this.getStringValue(i);
            }
            catch (DataNotAvailableException ex) {
                labels[j] = "";
            }
            i += 2;
        }
        return labels;
    }

    @Override
    public void addTargetLabel(int targetId, String targetLabel) {
        int[] ids = this.getTargetIds();
        String[] labels = this.getTargetLabels();
        String[] newFields = new String[(ids.length + 1) * 2];
        int i = 0;
        int j = 0;
        while (i < ids.length) {
            newFields[j] = String.valueOf(ids[i]);
            newFields[j + 1] = i < labels.length ? labels[i] : "";
            ++i;
            j += 2;
        }
        newFields[newFields.length - 2] = String.valueOf(targetId);
        newFields[newFields.length - 1] = targetLabel;
        this.setStringValues(0, newFields);
    }

    @Override
    public void setTargetPairs(int[] ids, String[] labels) {
        if (ids.length != labels.length) {
            throw new IllegalArgumentException("The ID and Label arrays must be the same length.");
        }
        String[] newFields = new String[ids.length * 2];
        int i = 0;
        int j = 0;
        while (i < ids.length) {
            newFields[j] = String.valueOf(ids[i]);
            newFields[j + 1] = labels[i];
            ++i;
            j += 2;
        }
        this.setStringValues(0, newFields);
    }
}

