/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.sentence.VBWSentence;
import net.sf.marineapi.nmea.util.DataStatus;

class VBWParser
extends SentenceParser
implements VBWSentence {
    public static final int LONG_WATERSPEED = 0;
    public static final int TRAV_WATERSPEED = 1;
    public static final int WATER_SPEED_STATUS = 2;
    public static final int LONG_GROUNDSPEED = 3;
    public static final int TRAV_GROUNDSPEED = 4;
    public static final int GROUND_SPEED_STATUS = 5;
    public static final int STERN_WATERSPEED = 6;
    public static final int STERN_SPEED_STATUS = 7;
    public static final int STERN_GROUNDSPEED = 8;
    public static final int STERN_GROUNDSPEED_STATUS = 9;

    public VBWParser(String nmea) {
        super(nmea, SentenceId.VBW);
    }

    public VBWParser(TalkerId talker) {
        super(talker, SentenceId.VBW, 10);
    }

    @Override
    public double getLongWaterSpeed() {
        return this.getDoubleValue(0);
    }

    @Override
    public DataStatus getWaterSpeedStatus() {
        return DataStatus.valueOf(this.getCharValue(2));
    }

    @Override
    public DataStatus getGroundSpeedStatus() {
        return DataStatus.valueOf(this.getCharValue(5));
    }

    @Override
    public double getLongGroundSpeed() {
        return this.getDoubleValue(3);
    }

    @Override
    public double getTravWaterSpeed() {
        return this.getDoubleValue(1);
    }

    @Override
    public double getTravGroundSpeed() {
        return this.getDoubleValue(4);
    }

    @Override
    public double getSternWaterSpeed() {
        return this.getDoubleValue(6);
    }

    @Override
    public DataStatus getSternWaterSpeedStatus() {
        return DataStatus.valueOf(this.getCharValue(7));
    }

    @Override
    public double getSternGroundSpeed() {
        return this.getDoubleValue(8);
    }

    @Override
    public DataStatus getSternGroundSpeedStatus() {
        return DataStatus.valueOf(this.getCharValue(9));
    }

    @Override
    public void setLongWaterSpeed(double speed) {
        this.setDoubleValue(0, speed, 2, 1);
    }

    @Override
    public void setLongGroundSpeed(double speed) {
        this.setDoubleValue(3, speed, 2, 1);
    }

    @Override
    public void setTravWaterSpeed(double speed) {
        this.setDoubleValue(1, speed, 2, 1);
    }

    @Override
    public void setTravGroundSpeed(double speed) {
        this.setDoubleValue(4, speed, 2, 1);
    }

    @Override
    public void setWaterSpeedStatus(DataStatus status) {
        this.setCharValue(2, status.toChar());
    }

    @Override
    public void setGroundSpeedStatus(DataStatus status) {
        this.setCharValue(5, status.toChar());
    }

    @Override
    public void setSternWaterSpeed(double speed) {
        this.setDoubleValue(6, speed, 2, 1);
    }

    @Override
    public void setSternWaterSpeedStatus(DataStatus status) {
        this.setCharValue(7, status.toChar());
    }

    @Override
    public void setSternGroundSpeed(double speed) {
        this.setDoubleValue(8, speed, 2, 1);
    }

    @Override
    public void setSternGroundSpeedStatus(DataStatus status) {
        this.setCharValue(9, status.toChar());
    }
}

