/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.provider;

import java.util.ArrayList;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.sentence.GSASentence;
import net.sf.marineapi.nmea.sentence.GSVSentence;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.util.SatelliteInfo;
import net.sf.marineapi.provider.AbstractProvider;
import net.sf.marineapi.provider.event.SatelliteInfoEvent;

public class SatelliteInfoProvider
extends AbstractProvider<SatelliteInfoEvent> {
    public SatelliteInfoProvider(SentenceReader reader) {
        super(reader, "GSA", "GSV");
    }

    @Override
    protected SatelliteInfoEvent createProviderEvent() {
        GSASentence gsa = null;
        ArrayList<SatelliteInfo> info = new ArrayList<SatelliteInfo>();
        for (Sentence sentence : this.getSentences()) {
            if ("GSA".equals(sentence.getSentenceId())) {
                gsa = (GSASentence)sentence;
                continue;
            }
            if (!"GSV".equals(sentence.getSentenceId())) continue;
            GSVSentence gsv = (GSVSentence)sentence;
            info.addAll(gsv.getSatelliteInfo());
        }
        return new SatelliteInfoEvent(this, gsa, info);
    }

    @Override
    protected boolean isReady() {
        boolean hasFirstGSV = false;
        boolean hasLastGSV = false;
        boolean hasAllGSV = false;
        int count = 0;
        for (Sentence s : this.getSentences()) {
            if (!"GSV".equals(s.getSentenceId())) continue;
            GSVSentence gsv = (GSVSentence)s;
            if (!hasFirstGSV) {
                hasFirstGSV = gsv.isFirst();
            }
            if (!hasLastGSV) {
                hasLastGSV = gsv.isLast();
            }
            hasAllGSV = gsv.getSentenceCount() == ++count;
        }
        return this.hasOne("GSA") && hasAllGSV && hasFirstGSV && hasLastGSV;
    }

    @Override
    protected boolean isValid() {
        return true;
    }
}

