/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ublox.parser;

import java.util.ArrayList;
import java.util.List;
import net.sf.marineapi.nmea.parser.DataNotAvailableException;
import net.sf.marineapi.nmea.sentence.UBXSentence;
import net.sf.marineapi.ublox.message.UBXMessage03;
import net.sf.marineapi.ublox.parser.UBXMessageParser;
import net.sf.marineapi.ublox.util.UbloxSatelliteInfo;
import net.sf.marineapi.ublox.util.UbloxSatelliteStatus;

class UBXMessage03Parser
extends UBXMessageParser
implements UBXMessage03 {
    private static final int NUMBER_OF_TRACKED_SATELLITES = 1;
    private static final int UBX_SATELLITE_ID = 2;
    private static final int SATELLITE_STATUS = 3;
    private static final int SATELLITE_AZIMUTH = 4;
    private static final int SATELLITE_ELEVATION = 5;
    private static final int SATELLITE_SIGNAL_STRENGTH = 6;
    private static final int SATELLIT_CARRIER_LOCK_TIME = 7;

    public UBXMessage03Parser(UBXSentence sentence) {
        super(sentence);
    }

    @Override
    public int getNumberOfTrackedSatellites() {
        return this.sentence.getUBXFieldIntValue(1);
    }

    @Override
    public List<UbloxSatelliteInfo> getSatellites() {
        int numberOfTrackedSatellites = this.getNumberOfTrackedSatellites();
        ArrayList<UbloxSatelliteInfo> satellites = new ArrayList<UbloxSatelliteInfo>(numberOfTrackedSatellites);
        for (int i = 0; i < numberOfTrackedSatellites; ++i) {
            int satelliteCarrierLockTime;
            int signalStrength;
            int satelliteElevation;
            int satelliteAzimuth;
            int satelliteId = this.sentence.getUBXFieldIntValue(2 + i * 6);
            UbloxSatelliteStatus satelliteStatus = UbloxSatelliteStatus.fromStatusFlag(this.sentence.getUBXFieldCharValue(3 + i * 6));
            try {
                satelliteAzimuth = this.sentence.getUBXFieldIntValue(4 + i * 6);
            }
            catch (DataNotAvailableException e) {
                satelliteAzimuth = -1;
            }
            try {
                satelliteElevation = this.sentence.getUBXFieldIntValue(5 + i * 6);
            }
            catch (DataNotAvailableException e) {
                satelliteElevation = -1;
            }
            try {
                signalStrength = this.sentence.getUBXFieldIntValue(6 + i * 6);
            }
            catch (DataNotAvailableException e) {
                signalStrength = -1;
            }
            try {
                satelliteCarrierLockTime = this.sentence.getUBXFieldIntValue(7 + i * 6);
            }
            catch (DataNotAvailableException e) {
                satelliteCarrierLockTime = -1;
            }
            UbloxSatelliteInfo satelliteInfo = new UbloxSatelliteInfo(String.valueOf(satelliteId), satelliteElevation, satelliteAzimuth, signalStrength, satelliteStatus, satelliteCarrierLockTime);
            satellites.add(satelliteInfo);
        }
        return satellites;
    }
}

