/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public final class GenericTypeResolver {
    private GenericTypeResolver() {
    }

    public static Class<?> resolve(Class<?> child, Class<?> parent) {
        Type t = GenericTypeResolver.resolve(child, parent, new HashMap());
        if (t == null || t instanceof TypeVariable) {
            throw new IllegalStateException("Cannot resolve generic type <T>, use constructor with Class<T> param.");
        }
        return (Class)t;
    }

    private static Type resolve(Class<?> child, Class<?> parent, Map<TypeVariable<?>, Type> types) {
        Type superClass = child.getGenericSuperclass();
        if (superClass instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)superClass;
            Class rawType = (Class)pt.getRawType();
            TypeVariable<Class<T>>[] typeParams = rawType.getTypeParameters();
            Type[] typeArgs = pt.getActualTypeArguments();
            for (int i = 0; i < typeParams.length; ++i) {
                if (typeArgs[i] instanceof TypeVariable) {
                    TypeVariable arg = (TypeVariable)typeArgs[i];
                    types.put(typeParams[i], types.containsKey(arg) ? types.get(arg) : arg);
                    continue;
                }
                types.put(typeParams[i], typeArgs[i]);
            }
            if (rawType == parent) {
                return types.containsKey(typeParams[0]) ? types.get(typeParams[0]) : typeParams[0];
            }
            return GenericTypeResolver.resolve(rawType, parent, types);
        }
        return GenericTypeResolver.resolve((Class)superClass, parent, types);
    }
}

