/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.sharedcache.jedis;

import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.coodex.sharedcache.SharedCacheClient;
import org.coodex.sharedcache.SharedCacheClientFactory;
import org.coodex.sharedcache.jedis.AbstractJedisClient;
import org.coodex.sharedcache.jedis.JedisClusterClient;
import org.coodex.sharedcache.jedis.JedisSingleNodeClient;
import org.coodex.util.Profile;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

public class JedisClientFactory
implements SharedCacheClientFactory {
    public static final String JEDIS_DRIVER_NAME = "jedis";
    public static final int DEFAULT_PORT = 6379;
    private static AbstractJedisClient client;
    private static Profile profile;

    public boolean isAccepted(String driverName) {
        if (driverName == null) {
            return false;
        }
        return JEDIS_DRIVER_NAME.equalsIgnoreCase(driverName.trim());
    }

    private HostAndPort toHostAndPort(String desc) {
        int index = desc.indexOf(58);
        if (index < 0) {
            return new HostAndPort(desc, 6379);
        }
        String host = desc.substring(0, index).trim();
        int port = Integer.valueOf(desc.substring(index + 1).trim());
        return new HostAndPort(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedCacheClient getClientInstance() {
        Class<JedisClientFactory> clazz = JedisClientFactory.class;
        synchronized (JedisClientFactory.class) {
            if (client == null) {
                profile = Profile.getProfile((String)"sharedcache-jedis.properties");
                String[] redisServers = profile.getStrList("redisServers");
                if (redisServers == null) {
                    throw new RuntimeException("no redis server defined.");
                }
                HashSet<HostAndPort> servers = new HashSet<HostAndPort>();
                for (String server : redisServers) {
                    try {
                        servers.add(this.toHostAndPort(server));
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("unknown redis server: " + server, e);
                    }
                }
                GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
                poolConfig.setMinIdle(profile.getInt("pool.minIdle", 0));
                poolConfig.setMaxIdle(profile.getInt("pool.maxIdle", 8));
                poolConfig.setMaxTotal(profile.getInt("pool.maxTotal", 8));
                if (servers.size() == 0) {
                    throw new RuntimeException("no redis server defined.");
                }
                long defaultMaxCacheTime = profile.getLong("defaultMaxCacheTime", DEFAULT_MAX_CACHED_SECENDS.longValue()) * 1000L;
                if (servers.size() == 1) {
                    String server;
                    server = (HostAndPort)servers.iterator().next();
                    client = new JedisSingleNodeClient(new JedisPool(poolConfig, server.getHost(), server.getPort()), defaultMaxCacheTime);
                } else {
                    client = new JedisClusterClient(new JedisCluster(servers, poolConfig), defaultMaxCacheTime);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return client;
        }
    }
}

