/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.sharedcache.jedis;

import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.coodex.sharedcache.SharedCacheClient;
import org.coodex.sharedcache.SharedCacheClientFactory;
import org.coodex.sharedcache.jedis.AbstractJedisClient;
import org.coodex.sharedcache.jedis.JedisClusterClient;
import org.coodex.sharedcache.jedis.JedisSingleNodeClient;
import org.coodex.util.Profile;
import org.coodex.util.Singleton;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

public class JedisClientFactory
implements SharedCacheClientFactory {
    public static final String JEDIS_DRIVER_NAME = "jedis";
    public static final int DEFAULT_PORT = 6379;
    private static Profile profile;
    private static Singleton<AbstractJedisClient> client;

    private static HostAndPort toHostAndPort(String desc) {
        int index = desc.indexOf(58);
        if (index < 0) {
            return new HostAndPort(desc, 6379);
        }
        String host = desc.substring(0, index).trim();
        int port = Integer.valueOf(desc.substring(index + 1).trim());
        return new HostAndPort(host, port);
    }

    public boolean isAccepted(String driverName) {
        if (driverName == null) {
            return false;
        }
        return JEDIS_DRIVER_NAME.equalsIgnoreCase(driverName.trim());
    }

    public SharedCacheClient getClientInstance() {
        return (SharedCacheClient)client.getInstance();
    }

    static {
        client = new Singleton((Singleton.Builder)new Singleton.Builder<AbstractJedisClient>(){

            public AbstractJedisClient build() {
                profile = Profile.getProfile((String)"sharedcache-jedis.properties");
                String[] redisServers = profile.getStrList("redisServers");
                if (redisServers == null) {
                    throw new RuntimeException("no redis server defined.");
                }
                HashSet<HostAndPort> servers = new HashSet<HostAndPort>();
                for (String server : redisServers) {
                    try {
                        servers.add(JedisClientFactory.toHostAndPort(server));
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("unknown redis server: " + server, e);
                    }
                }
                GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
                poolConfig.setMinIdle(profile.getInt("pool.minIdle", 0));
                poolConfig.setMaxIdle(profile.getInt("pool.maxIdle", 8));
                poolConfig.setMaxTotal(profile.getInt("pool.maxTotal", 8));
                if (servers.size() == 0) {
                    throw new RuntimeException("no redis server defined.");
                }
                long defaultMaxCacheTime = profile.getLong("defaultMaxCacheTime", SharedCacheClientFactory.DEFAULT_MAX_CACHED_SECENDS.longValue()) * 1000L;
                if (servers.size() == 1) {
                    String server;
                    server = (HostAndPort)servers.iterator().next();
                    return new JedisSingleNodeClient(new JedisPool(poolConfig, server.getHost(), server.getPort()), defaultMaxCacheTime);
                }
                return new JedisClusterClient(new JedisCluster(servers, poolConfig), defaultMaxCacheTime);
            }
        });
    }
}

