/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.sharedcache.jedis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.coodex.sharedcache.SharedCacheClient;
import org.coodex.sharedcache.jedis.JedisAdaptor;

public abstract class AbstractJedisClient
implements SharedCacheClient {
    private long default_max_cache_time;

    public AbstractJedisClient(long default_max_cache_time) {
        this.default_max_cache_time = default_max_cache_time;
    }

    protected abstract JedisAdaptor getCommand();

    protected void assertKey(String key) {
        if (key == null) {
            throw new NullPointerException("cache key is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <T extends Serializable> T get(String key) {
        this.assertKey(key);
        JedisAdaptor commands = this.getCommand();
        try {
            byte[] buff = commands.get(key.getBytes());
            if (buff == null) {
                T t = null;
                return t;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(buff);
            ObjectInputStream ois = null;
            ois = new ObjectInputStream(bis);
            Serializable serializable = (Serializable)ois.readObject();
            ois.close();
            return (T)serializable;
            {
                catch (Throwable throwable) {
                    try {
                        ois.close();
                        throw throwable;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        finally {
            commands.close();
        }
    }

    public void put(String key, Serializable value) {
        this.put(key, value, this.default_max_cache_time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Serializable value, long max_cached_time) {
        this.assertKey(key);
        if (value == null || max_cached_time <= 0L) {
            this.remove(key);
            return;
        }
        JedisAdaptor commands = this.getCommand();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            try {
                oos.writeObject(value);
                byte[] keyBuf = key.getBytes();
                commands.set(keyBuf, bos.toByteArray());
                if (max_cached_time > 0L) {
                    commands.pexpire(keyBuf, max_cached_time);
                }
            }
            finally {
                oos.close();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            commands.close();
        }
    }

    public void remove(String key) {
        if (key == null) {
            return;
        }
        JedisAdaptor commands = this.getCommand();
        try {
            commands.del(key.getBytes());
        }
        finally {
            commands.close();
        }
    }
}

