/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.sharedcache.jedis;

import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.coodex.config.Config;
import org.coodex.sharedcache.SharedCacheClient;
import org.coodex.sharedcache.SharedCacheClientFactory;
import org.coodex.sharedcache.jedis.AbstractJedisClient;
import org.coodex.sharedcache.jedis.JedisClusterClient;
import org.coodex.sharedcache.jedis.JedisSingleNodeClient;
import org.coodex.util.Singleton;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

public class JedisClientFactory
implements SharedCacheClientFactory {
    public static final String JEDIS_DRIVER_NAME = "jedis";
    public static final String NAMESPACE_JEDIS = "sharedcache-jedis";
    public static final int DEFAULT_PORT = 6379;
    private static Singleton<AbstractJedisClient> client = new Singleton((Singleton.Builder)new Singleton.Builder<AbstractJedisClient>(){

        public AbstractJedisClient build() {
            String[] redisServers = Config.getArray((String)"redisServers", (String[])new String[]{JedisClientFactory.NAMESPACE_JEDIS});
            if (redisServers == null) {
                throw new RuntimeException("no redis server defined.");
            }
            HashSet<HostAndPort> servers = new HashSet<HostAndPort>();
            for (String server : redisServers) {
                try {
                    servers.add(JedisClientFactory.toHostAndPort(server));
                }
                catch (Throwable e) {
                    throw new RuntimeException("unknown redis server: " + server, e);
                }
            }
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMinIdle(((Integer)Config.getValue((String)"pool.minIdle", (Object)0, (String[])new String[]{JedisClientFactory.NAMESPACE_JEDIS})).intValue());
            poolConfig.setMaxIdle(((Integer)Config.getValue((String)"pool.maxIdle", (Object)8, (String[])new String[]{JedisClientFactory.NAMESPACE_JEDIS})).intValue());
            poolConfig.setMaxTotal(((Integer)Config.getValue((String)"pool.maxTotal", (Object)8, (String[])new String[]{JedisClientFactory.NAMESPACE_JEDIS})).intValue());
            if (servers.size() == 0) {
                throw new RuntimeException("no redis server defined.");
            }
            long defaultMaxCacheTime = (Long)Config.getValue((String)"defaultMaxCacheTime", (Object)SharedCacheClientFactory.DEFAULT_MAX_CACHED_SECENDS, (String[])new String[]{JedisClientFactory.NAMESPACE_JEDIS}) * 1000L;
            if (servers.size() == 1) {
                String server;
                server = (HostAndPort)servers.iterator().next();
                return new JedisSingleNodeClient(new JedisPool(poolConfig, server.getHost(), server.getPort()), defaultMaxCacheTime);
            }
            return new JedisClusterClient(new JedisCluster(servers, poolConfig), defaultMaxCacheTime);
        }
    });

    private static HostAndPort toHostAndPort(String desc) {
        int index = desc.indexOf(58);
        if (index < 0) {
            return new HostAndPort(desc, 6379);
        }
        String host = desc.substring(0, index).trim();
        int port = Integer.valueOf(desc.substring(index + 1).trim());
        return new HostAndPort(host, port);
    }

    public boolean isAccepted(String driverName) {
        if (driverName == null) {
            return false;
        }
        return JEDIS_DRIVER_NAME.equalsIgnoreCase(driverName.trim());
    }

    public SharedCacheClient getClientInstance() {
        return (SharedCacheClient)client.get();
    }
}

