/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.sharedcache.memcached;

import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClientBuilder;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.coodex.sharedcache.SharedCacheClient;
import org.coodex.sharedcache.SharedCacheClientFactory;
import org.coodex.sharedcache.memcached.XMemcachedCacheClient;
import org.coodex.util.Common;
import org.coodex.util.Profile;

public class XMemcachedCacheClientFactory
implements SharedCacheClientFactory {
    public static final String DRIVER_NAME = "xmemcached";
    private MemcachedClientBuilder builder;
    private Profile profile = Profile.getProfile((String)"sharedcache-xmemcached.properties");

    public boolean isAccepted(String driverName) {
        if (Common.isBlank((String)driverName)) {
            return false;
        }
        return DRIVER_NAME.equalsIgnoreCase(driverName.trim());
    }

    public SharedCacheClient getClientInstance() {
        this.init();
        return new XMemcachedCacheClient(this.builder, this.profile.getLong("defaultMaxCacheTime", DEFAULT_MAX_CACHED_SECENDS.longValue()) * 1000L);
    }

    private synchronized void init() {
        if (this.builder == null) {
            String[] servers = this.profile.getStrList("memcachedServers", " ");
            if (servers == null || servers.length == 0) {
                throw new RuntimeException("no memcached server defined.");
            }
            XMemcachedClientBuilder memcachedClientBuilder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)this.profile.getString("memcachedServers")));
            memcachedClientBuilder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
            memcachedClientBuilder.setConnectionPoolSize(this.profile.getInt("poolSize", 1));
            for (String server : servers) {
                String username = this.profile.getString("user." + server);
                if (Common.isBlank((String)username)) continue;
                String password = this.profile.getString("pwd." + server);
                memcachedClientBuilder.addAuthInfo(AddrUtil.getOneAddress((String)server), AuthInfo.typical((String)username, (String)password));
            }
            this.builder = memcachedClientBuilder;
        }
    }
}

