/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.sharedcache.memcached;

import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClientBuilder;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.coodex.config.Config;
import org.coodex.sharedcache.SharedCacheClient;
import org.coodex.sharedcache.SharedCacheClientFactory;
import org.coodex.sharedcache.memcached.XMemcachedCacheClient;
import org.coodex.util.Common;

public class XMemcachedCacheClientFactory
implements SharedCacheClientFactory {
    public static final String DRIVER_NAME = "xmemcached";
    public static final String NAMESPACE_XMEMCHACHED = "sharedcache-xmemcached";
    private MemcachedClientBuilder builder;

    public boolean isAccepted(String driverName) {
        if (Common.isBlank((String)driverName)) {
            return false;
        }
        return DRIVER_NAME.equalsIgnoreCase(driverName.trim());
    }

    public SharedCacheClient getClientInstance() {
        this.init();
        return new XMemcachedCacheClient(this.builder, (Long)Config.getValue((String)"defaultMaxCacheTime", (Object)DEFAULT_MAX_CACHED_SECONDS, (String[])new String[]{NAMESPACE_XMEMCHACHED}) * 1000L);
    }

    private synchronized void init() {
        if (this.builder == null) {
            String[] servers = Common.toArray((String)Config.get((String)"memchachedServers", (String[])new String[]{NAMESPACE_XMEMCHACHED}), (String)" ", (String[])null);
            if (servers == null || servers.length == 0) {
                throw new RuntimeException("no memcached server defined.");
            }
            XMemcachedClientBuilder memcachedClientBuilder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)Config.get((String)"memcachedServers", (String[])new String[]{NAMESPACE_XMEMCHACHED})));
            memcachedClientBuilder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
            memcachedClientBuilder.setConnectionPoolSize(((Integer)Config.getValue((String)"poolSize", (Object)1, (String[])new String[]{NAMESPACE_XMEMCHACHED})).intValue());
            for (String server : servers) {
                String username = Config.get((String)("user." + server), (String[])new String[]{NAMESPACE_XMEMCHACHED});
                if (Common.isBlank((String)username)) continue;
                String password = Config.get((String)("pwd." + server), (String[])new String[]{NAMESPACE_XMEMCHACHED});
                memcachedClientBuilder.addAuthInfo(AddrUtil.getOneAddress((String)server), AuthInfo.typical((String)username, (String)password));
            }
            this.builder = memcachedClientBuilder;
        }
    }

    public boolean accept(String param) {
        return this.isAccepted(param);
    }
}

