/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.sharedcache.memcached;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientBuilder;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.coodex.sharedcache.SharedCacheClient;
import org.coodex.util.Common;

public class XMemcachedCacheClient
implements SharedCacheClient {
    private MemcachedClientBuilder builder;
    private long max_cached_time;

    public XMemcachedCacheClient(MemcachedClientBuilder builder, long max_cached_time) {
        this.builder = builder;
        this.max_cached_time = max_cached_time;
    }

    protected void assertKey(String key) {
        if (key == null) {
            throw new NullPointerException("cache key is null.");
        }
    }

    protected MemcachedClient getClient() throws IOException, InterruptedException, MemcachedException, TimeoutException {
        MemcachedClient client = this.builder.build();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Serializable> T get(String key) {
        this.assertKey(key);
        try {
            MemcachedClient client = this.getClient();
            try {
                Serializable serializable = (Serializable)client.get(key);
                return (T)serializable;
            }
            finally {
                if (client != null) {
                    client.shutdown();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Throwable e) {
            throw Common.rte((Throwable)e);
        }
    }

    public void put(String key, Serializable value) {
        this.put(key, value, this.max_cached_time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Serializable value, long max_cached_time) {
        this.assertKey(key);
        int idleTime = (int)(max_cached_time / 1000L);
        if (idleTime <= 0) {
            throw new IllegalArgumentException("idleTime must be larger then one second.");
        }
        try {
            MemcachedClient client = this.getClient();
            try {
                client.set(key, idleTime, (Object)value);
            }
            finally {
                if (client != null) {
                    client.shutdown();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            throw Common.rte((Throwable)e);
        }
    }

    public void remove(String key) {
        if (key == null) {
            return;
        }
        try {
            MemcachedClient client = this.getClient();
            try {
                client.deleteWithNoReply(key);
            }
            finally {
                if (client != null) {
                    client.shutdown();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            throw Common.rte((Throwable)e);
        }
    }
}

