/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.sharedcache;

import java.util.ServiceLoader;
import org.coodex.sharedcache.SharedCacheClient;
import org.coodex.sharedcache.SharedCacheClientFactory;
import org.coodex.sharedcache.SharedCacheClientFactoryProviderNotFoundException;
import org.coodex.util.Singleton;

public class SharedCacheClientManager {
    private static Singleton<ServiceLoader<SharedCacheClientFactory>> factoryProviders = new Singleton((Singleton.Builder)new Singleton.Builder<ServiceLoader<SharedCacheClientFactory>>(){

        public ServiceLoader<SharedCacheClientFactory> build() {
            return ServiceLoader.load(SharedCacheClientFactory.class);
        }
    });

    private static void load() {
        factoryProviders.getInstance();
    }

    public static SharedCacheClient getClient(String driverName) {
        if (driverName == null) {
            throw new NullPointerException("distributed cache driverName must not be NULL.");
        }
        SharedCacheClientManager.load();
        for (SharedCacheClientFactory factory : (ServiceLoader)factoryProviders.getInstance()) {
            if (!factory.isAccepted(driverName)) continue;
            return factory.getClientInstance();
        }
        throw new SharedCacheClientFactoryProviderNotFoundException(driverName);
    }
}

