/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.test.boot;

import java.util.EventListener;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import org.coodex.concrete.core.token.TokenManager;
import org.coodex.concrete.core.token.local.LocalTokenManager;
import org.coodex.concrete.dubbo.DubboHelper;
import org.coodex.concrete.spring.ConcreteSpringConfiguration;
import org.coodex.concrete.support.dubbo.DubboApplication;
import org.coodex.concrete.support.jsr339.ConcreteJaxrs339Application;
import org.coodex.concrete.support.websocket.CallerHackConfigurator;
import org.coodex.concrete.support.websocket.ConcreteWebSocketApplication;
import org.coodex.concrete.test.api.Test;
import org.coodex.concrete.test.impl.TestImpl;
import org.coodex.util.Profile;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;

@SpringBootApplication
@Configuration
@EnableAspectJAutoProxy
@Import(value={ConcreteSpringConfiguration.class})
public class ServiceStarter {
    private static Profile profile = Profile.getProfile((String)"env.properties");

    @Bean
    public ServletRegistrationBean jaxrsServlet() {
        ServletContainer container = new ServletContainer();
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)container, new String[]{"/jaxrs/*"});
        registrationBean.addInitParameter("javax.ws.rs.Application", JaxRSApplication.class.getName());
        registrationBean.setName("demo");
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    public ServletRegistrationBean webSocketServlet() {
        ServletContainer container = new ServletContainer();
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)container, new String[]{"/WebSocket"}){

            public void onStartup(ServletContext servletContext) throws ServletException {
                servletContext.addListener((EventListener)new ServletContextListener(){

                    public void contextInitialized(ServletContextEvent sce) {
                        ServerContainer serverContainer = (ServerContainer)sce.getServletContext().getAttribute("javax.websocket.server.ServerContainer");
                        try {
                            serverContainer.addEndpoint(WebsocketApplication.class);
                        }
                        catch (DeploymentException e) {
                            e.printStackTrace();
                        }
                    }

                    public void contextDestroyed(ServletContextEvent sce) {
                    }
                });
            }
        };
        registrationBean.setName("demo");
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    public DubboApplication dubboApplication() {
        DubboApplication dubboApplication = new DubboApplication("test", DubboHelper.buildRegistryConfigs((String[])new String[]{profile.getString("registry")}), new int[0]);
        dubboApplication.register(new Class[]{Test.class});
        return dubboApplication;
    }

    @Bean
    public TokenManager tokenManager() {
        return new LocalTokenManager();
    }

    @Bean
    public Test getTest() {
        return new TestImpl();
    }

    public static void main(String[] args) {
        SpringApplication.run(ServiceStarter.class, (String[])new String[0]);
    }

    @ServerEndpoint(value="/WebSocket", configurator=CallerHackConfigurator.class)
    public static class WebsocketApplication
    extends ConcreteWebSocketApplication {
        public WebsocketApplication() {
            this.register(new Class[]{Test.class});
        }
    }

    public static class JaxRSApplication
    extends ConcreteJaxrs339Application {
        public JaxRSApplication() {
            this.register(new Class[]{JacksonFeature.class, LoggingFeature.class, Test.class});
        }
    }
}

