/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.test.impl;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.io.Serializable;
import javax.inject.Inject;
import org.coodex.concrete.ConcreteClient;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.concrete.test.api.Test;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.org.coodex.concrete.test.api.Test_RX;

public class TestImpl
implements Test {
    private static final Logger log = LoggerFactory.getLogger(TestImpl.class);
    private Token token = TokenWrapper.getInstance();
    @Inject
    @ConcreteClient(value="local")
    private Test local;
    @Inject
    @ConcreteClient(value="local")
    private Test_RX localRx;
    @Inject
    @ConcreteClient(value="jaxrs")
    private Test jaxrs;
    @Inject
    @ConcreteClient(value="jaxrs")
    private Test_RX jaxrsRx;
    @Inject
    @ConcreteClient(value="websocket")
    private Test websocket;
    @Inject
    @ConcreteClient(value="websocket")
    private Test_RX websocketRx;

    public int add(int x1, int x2) {
        this.token.setAttribute("a", (Serializable)((Object)"sdf"));
        return x1 + x2;
    }

    public String sayHello(String name) {
        this.invokeSync(this.local, "local");
        this.invokeSync(this.jaxrs, "jaxrs");
        this.invokeSync(this.websocket, "websocket");
        this.invokeRx(this.localRx, "local");
        this.invokeRx(this.jaxrsRx, "jaxrs");
        this.invokeRx(this.websocketRx, "websocket");
        return "Hello " + name;
    }

    private void invokeRx(Test_RX test, final String tag) {
        final int x1 = Common.random((int)100);
        final int x2 = Common.random((int)100);
        test.add(x1, x2).subscribe((Observer)new Observer<Integer>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(Integer integer) {
                log.info("invoke add ({}, {}) = {} from [{}]", new Object[]{x1, x2, integer, tag});
            }

            public void onError(Throwable e) {
                log.info("invoke add ({}, {}) = ? from [{}]", new Object[]{x1, x2, tag, e});
            }

            public void onComplete() {
                log.info("invoke add ({}, {}) complete", (Object)x1, (Object)x2);
            }
        });
    }

    private void invokeSync(Test test, String tag) {
        int x1 = Common.random((int)100);
        int x2 = Common.random((int)100);
        log.info("invoke add ({}, {}) = {} from [{}]", new Object[]{x1, x2, test.add(x1, x2), tag});
    }
}

