/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.test.impl;

import java.io.Serializable;
import javax.inject.Inject;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.intercept.AbstractTokenBasedTopicSubscribeInterceptor;
import org.coodex.concrete.message.MessageConsumer;
import org.coodex.concrete.message.MessageFilter;
import org.coodex.concrete.test.impl.TestSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MessageConsumer(queue="test")
public class SubscribeInterceptor
extends AbstractTokenBasedTopicSubscribeInterceptor<TestSubject> {
    public static final String SUBSCRIBED = "org.coodex.token.subscribed";
    public static final String SUBSCRIBED_NUMBER_KEY = "X1";
    private static final Logger log = LoggerFactory.getLogger(SubscribeInterceptor.class);
    @Inject
    private Token token;

    protected boolean checkAccountCredible() {
        return false;
    }

    protected MessageFilter<TestSubject> subscribe() {
        final Integer x1 = (Integer)this.token.getAttribute(SUBSCRIBED_NUMBER_KEY, Integer.class);
        this.token.setAttribute(SUBSCRIBED, (Serializable)Boolean.valueOf(true));
        log.debug("TestSubject subscribed.");
        return new MessageFilter<TestSubject>(){

            public boolean handle(TestSubject message) {
                return message.getNumber() == x1.intValue();
            }
        };
    }

    protected boolean check() {
        return this.token.getAttribute(SUBSCRIBED, Object.class) == null && this.token.getAttribute(SUBSCRIBED_NUMBER_KEY, Object.class) != null;
    }
}

