/*
 * Copyright (c) 2017 coodex.org (jujus.shen@126.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.coodex.practice.jaxrs.impl;

import org.apache.commons.codec.binary.Base64;
import org.aspectj.lang.annotation.Aspect;
import org.coodex.concrete.core.intercept.SignatureInterceptor;
import org.coodex.concrete.spring.aspects.AbstractConcreteAspect;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;

/**
 * Created by davidoff shen on 2017-04-25.
 */
@Aspect
public class SignatureAspect extends AbstractConcreteAspect<SignatureInterceptor> {

    public static void main(String [] args){
        try{
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(1024);
            KeyPair keyPair = generator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();

            System.out.println("privateKey: ");
            System.out.println(Base64.encodeBase64String(privateKey.getEncoded()));

            System.out.println("publicKey: ");
            System.out.println(Base64.encodeBase64String(publicKey.getEncoded()));
        }catch (Throwable throwable){
            throwable.printStackTrace();
        }
    }
}
