/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.practice.jaxrs.jersey;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.coodex.concrete.attachments.server.DownloadResource;
import org.coodex.concrete.attachments.server.UploadByFormResource;
import org.coodex.concrete.jaxrs.ConcreteExceptionMapper;
import org.coodex.concrete.jaxrs.CreatedByConcrete;
import org.coodex.concrete.jaxrs.JaxRSServiceHelper;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleApplication
extends ResourceConfig {
    private static final Logger log = LoggerFactory.getLogger(ExampleApplication.class);
    private static final String GENERATOR_NAME = "JaxRS.jsr339.javassist.v1";

    public ExampleApplication() {
        this.registerClasses(new Class[]{JacksonFeature.class, LoggingFeature.class, ConcreteExceptionMapper.class, DownloadResource.class, UploadByFormResource.class});
        Set classes = JaxRSServiceHelper.generateByPackages((String)GENERATOR_NAME, (String[])new String[0]);
        log.info("{} classes created.", (Object)classes.size());
        for (Class clz : classes) {
            log.debug("class: {}, Annotation:{}", (Object)clz, (Object)Arrays.deepToString(clz.getAnnotations()));
            for (Method method : clz.getDeclaredMethods()) {
                log.debug("method: {}", (Object)method);
                log.debug("Method Annotations: {}", (Object)Arrays.deepToString(method.getAnnotations()));
                log.debug("Method param: {}", (Object)Arrays.deepToString((Object[])method.getParameterAnnotations()));
                log.debug("Method Parameters: {}", (Object)Arrays.deepToString(method.getGenericParameterTypes()));
                for (Class<?> c : method.getParameterTypes()) {
                    if (!c.getName().startsWith("POJO$")) continue;
                    for (Field field : c.getFields()) {
                        log.debug("field: {}, {}", (Object)field.getName(), (Object)field.getGenericType());
                    }
                }
            }
        }
        this.register(ConcreteExceptionMapper.class);
        this.registerClasses(classes);
    }

    public static void main(String[] args) {
        Set classes = JaxRSServiceHelper.generateByPackages((String)GENERATOR_NAME, (String[])new String[]{"org.coodex.practice.jaxrs.api"});
        log.debug("{} classes created.", (Object)classes.size());
        for (Class clz : classes) {
            log.debug("class: {}, Annotation:{}", (Object)clz, (Object)clz.getAnnotations());
            for (Method method : clz.getMethods()) {
                if (method.getAnnotation(CreatedByConcrete.class) == null) continue;
                log.debug("method: {}, Annotations: {}", (Object)method.toGenericString(), (Object)method.getAnnotations());
                log.debug("param: {}", (Object)Arrays.deepToString((Object[])method.getParameterAnnotations()));
            }
        }
    }
}

