/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.practice.jaxrs.starter;

import java.util.Arrays;
import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerContainer;
import org.coodex.concrete.spring.ConcreteSpringConfiguration;
import org.coodex.concrete.support.jsr339.ConcreteJaxrs339Application;
import org.coodex.concrete.support.websocket.CallerHackFilter;
import org.coodex.practice.jaxrs.jersey.ExampleApplication;
import org.coodex.practice.jaxrs.starter.TestWebSocketServer;
import org.coodex.servlet.cors.CorsFilter;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.boot.web.support.SpringBootServletInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;

@SpringBootApplication
@Configuration
@Import(value={ConcreteSpringConfiguration.class})
@ImportResource(value={"classpath:example.xml"})
public class Starter
extends SpringBootServletInitializer {
    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.sources(new Class[]{Starter.class});
    }

    @Bean
    public ServletContainer getServletContainer() {
        return new ServletContainer();
    }

    @Bean
    public ServletRegistrationBean testServlet() {
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)this.getServletContainer(), new String[]{"/jaxrs/*"});
        registrationBean.addInitParameter("javax.ws.rs.Application", ApplicationExample.class.getName());
        registrationBean.setName("test");
        registrationBean.setAsyncSupported(true);
        registrationBean.setLoadOnStartup(1);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean wsFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new CallerHackFilter());
        filterRegistrationBean.setAsyncSupported(true);
        filterRegistrationBean.setUrlPatterns(Arrays.asList("/WebSocket"));
        return filterRegistrationBean;
    }

    @Bean
    public ServletRegistrationBean wsServlet() {
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)this.getServletContainer(), new String[]{"/WebSocket"}){

            public void onStartup(ServletContext servletContext) throws ServletException {
                servletContext.addListener((EventListener)new ServletContextListener(){

                    public void contextInitialized(ServletContextEvent sce) {
                        ServerContainer serverContainer = (ServerContainer)sce.getServletContext().getAttribute("javax.websocket.server.ServerContainer");
                        try {
                            serverContainer.addEndpoint(TestWebSocketServer.class);
                        }
                        catch (DeploymentException e) {
                            e.printStackTrace();
                        }
                    }

                    public void contextDestroyed(ServletContextEvent sce) {
                    }
                });
            }
        };
        registrationBean.addInitParameter("javax.ws.rs.Application", ExampleApplication.class.getName());
        registrationBean.setName("test");
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean corsFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new CorsFilter());
        filterRegistrationBean.setAsyncSupported(true);
        filterRegistrationBean.setUrlPatterns(Arrays.asList("/*"));
        return filterRegistrationBean;
    }

    public static void main(String[] args) {
        SpringApplication.run((Object[])new Object[]{Starter.class}, (String[])args);
    }

    public static class ApplicationExample
    extends ConcreteJaxrs339Application {
        public ApplicationExample() {
            this.register(new Class[]{JacksonFeature.class, LoggingFeature.class});
            this.registerPackage(new String[0]);
        }
    }
}

