/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.TraceConstants;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.AFSerializer;
import org.coos.util.serialize.HashtableHelper;
import org.coos.util.serialize.StringHelper;
import org.coos.util.serialize.VectorHelper;

public class ActorReport
implements AFSerializer {
    public String RequestType;
    public ActorAddress myId;
    public ActorAddress myParrentId;
    private Hashtable myProperties;
    public String myState;
    public String myStateData;
    public Vector myChildren = new Vector();
    public Vector myRequestedRoles;
    public Vector yourRequestedRoles;
    public boolean active;
    public int traceLevel;
    public Vector myRoles;
    public String status;
    private String result;
    private String repstatus = "Status of the report request: ";
    private int tabLength;
    public Hashtable ports;

    public ActorReport() {
    }

    public Vector getChildrenOfType(String type) {
        if (this.myChildren == null) {
            return new Vector();
        }
        Vector<ActorReport> res = new Vector<ActorReport>();
        for (int x = 0; x < this.myChildren.size(); ++x) {
            ActorReport ar = (ActorReport)this.myChildren.elementAt(x);
            if (!ar.myId.getActorType().equals(type)) continue;
            res.addElement(ar);
        }
        return res;
    }

    public String printActorReport() {
        this.result = "Status Report of type: " + this.RequestType + "\n\n";
        this.tabLength = -1;
        this.getActorReport(this);
        if (this.repstatus != null) {
            this.result = this.result + this.status;
        }
        return this.result;
    }

    public String getActorReport(ActorReport actorReport) {
        ActorAddress aa;
        Enumeration i;
        if (actorReport.status != null) {
            this.repstatus = this.repstatus + actorReport.status;
        }
        this.result = this.result + "ACTOR: " + actorReport.myId + " STATE: " + actorReport.myState + "  STATE DATA: " + actorReport.myStateData;
        this.result = this.result + " TRACE LEVEL: " + TraceConstants.getTraceLevel(actorReport.traceLevel);
        this.result = this.result + " ROLES: ";
        if (actorReport.myRoles != null) {
            i = actorReport.myRoles.elements();
            while (i.hasMoreElements()) {
                this.result = this.result + i.nextElement();
            }
        }
        this.result = this.result + "  REQUESTED ROLES: ";
        if (actorReport.myRequestedRoles != null) {
            i = actorReport.myRequestedRoles.elements();
            while (i.hasMoreElements()) {
                aa = (ActorAddress)i.nextElement();
                this.result = this.result + aa.toString() + ", ";
            }
        }
        this.result = this.result + "  REQUESTOR ROLES: ";
        if (actorReport.yourRequestedRoles != null) {
            i = actorReport.yourRequestedRoles.elements();
            while (i.hasMoreElements()) {
                aa = (ActorAddress)i.nextElement();
                this.result = this.result + aa.toString() + ", ";
            }
        }
        this.result = this.result + "\n";
        if (actorReport.myChildren != null) {
            i = actorReport.myChildren.elements();
            ++this.tabLength;
            while (i.hasMoreElements()) {
                for (int j = this.tabLength; j >= 0; --j) {
                    this.result = this.result + "-->";
                }
                this.getActorReport((ActorReport)i.nextElement());
            }
        } else {
            this.result = this.result + " NO OF CHILDREN: ";
        }
        --this.tabLength;
        return "not supported";
    }

    public String printXMLActorReport() {
        return "<xml>" + this.getXMLActorReport(this) + "</xml>";
    }

    public String getXMLActorReport(ActorReport actorReport) {
        ActorAddress aa;
        Enumeration<Object> i;
        if (actorReport.status != null) {
            this.repstatus = this.repstatus + actorReport.status;
        }
        this.result = this.result + "<actor>" + actorReport.myId.keyWithOutPort() + "<content><state>" + actorReport.myState + "</state><statedata>" + actorReport.myStateData + "</statedata>";
        this.result = this.result + "<tracelevel>" + TraceConstants.getTraceLevel(actorReport.traceLevel) + "</tracelevel>";
        this.result = this.result + "<actoraddress>";
        this.result = this.result + "<actorport>" + actorReport.myId.getActorPort() + "</actorport>";
        this.result = this.result + "<actorip>" + actorReport.myId.getActorIP() + "</actorip>";
        this.result = this.result + "</actoraddress>";
        this.result = this.result + "<ports>";
        if (actorReport.ports != null) {
            i = actorReport.ports.keys();
            while (i.hasMoreElements()) {
                String portname = (String)i.nextElement();
                this.result = this.result + portname + "\n";
            }
        }
        this.result = this.result + "</ports>";
        this.result = this.result + "<roles>";
        if (actorReport.myRoles != null) {
            i = actorReport.myRoles.elements();
            while (i.hasMoreElements()) {
                this.result = this.result + i.nextElement();
            }
        }
        this.result = this.result + "</roles><requestedRoles>";
        if (actorReport.myRequestedRoles != null) {
            i = actorReport.myRequestedRoles.elements();
            while (i.hasMoreElements()) {
                aa = (ActorAddress)i.nextElement();
                this.result = this.result + aa.toString() + ", ";
            }
        }
        this.result = this.result + "</requestedRoles><requestorRoles>";
        if (actorReport.yourRequestedRoles != null) {
            i = actorReport.yourRequestedRoles.elements();
            while (i.hasMoreElements()) {
                aa = (ActorAddress)i.nextElement();
                this.result = this.result + aa.toString() + ", ";
            }
        }
        this.result = this.result + "</requestorRoles></content>\n";
        if (actorReport.myChildren != null) {
            i = actorReport.myChildren.elements();
            ++this.tabLength;
            while (i.hasMoreElements()) {
                this.getXMLActorReport((ActorReport)i.nextElement());
            }
        } else {
            this.result = this.result + " NO OF CHILDREN: ";
        }
        this.result = this.result + "</actor>\n";
        return this.result;
    }

    public ActorReport(DataInputStream din, AFClassLoader cl) throws IOException {
        this.RequestType = StringHelper.resurrect((DataInputStream)din);
        this.myId = new ActorAddress(din);
        this.myParrentId = new ActorAddress(din);
        this.myState = StringHelper.resurrect((DataInputStream)din);
        this.myStateData = StringHelper.resurrect((DataInputStream)din);
        this.myChildren = VectorHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.myRequestedRoles = VectorHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.yourRequestedRoles = VectorHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.active = din.readBoolean();
        this.traceLevel = din.readInt();
        this.myRoles = VectorHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.status = StringHelper.resurrect((DataInputStream)din);
        this.myProperties = HashtableHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        ((OutputStream)dout).write(StringHelper.persist((String)this.RequestType));
        ((OutputStream)dout).write(this.myId.serialize());
        ((OutputStream)dout).write(this.myParrentId.serialize());
        ((OutputStream)dout).write(StringHelper.persist((String)this.myState));
        ((OutputStream)dout).write(StringHelper.persist((String)this.myStateData));
        ((OutputStream)dout).write(VectorHelper.persist((Vector)this.myChildren));
        ((OutputStream)dout).write(VectorHelper.persist((Vector)this.myRequestedRoles));
        ((OutputStream)dout).write(VectorHelper.persist((Vector)this.yourRequestedRoles));
        dout.writeBoolean(this.active);
        dout.writeInt(this.traceLevel);
        ((OutputStream)dout).write(VectorHelper.persist((Vector)this.myRoles));
        ((OutputStream)dout).write(StringHelper.persist((String)this.status));
        ((OutputStream)dout).write(HashtableHelper.persist((Hashtable)this.myProperties));
        dout.flush();
        return bout.toByteArray();
    }

    public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        this.RequestType = StringHelper.resurrect((DataInputStream)din);
        this.myId = new ActorAddress(din);
        this.myParrentId = new ActorAddress(din);
        this.myState = StringHelper.resurrect((DataInputStream)din);
        this.myStateData = StringHelper.resurrect((DataInputStream)din);
        this.myChildren = VectorHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.myRequestedRoles = VectorHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.yourRequestedRoles = VectorHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.active = din.readBoolean();
        this.traceLevel = din.readInt();
        this.myRoles = VectorHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.status = StringHelper.resurrect((DataInputStream)din);
        this.myProperties = HashtableHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        return bin;
    }

    public Hashtable getMyProperties() {
        return this.myProperties;
    }

    public void setMyProperties(Hashtable myProperties) {
        this.myProperties = myProperties;
    }
}

