/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class CLDCLoggingEvent {
    private byte[] seg1 = new byte[]{-84, -19, 0, 5, 115, 114, 0, 33, 111, 114, 103, 46, 97, 112, 97, 99, 104, 101, 46, 108, 111, 103, 52, 106, 46, 115, 112, 105, 46, 76, 111, 103, 103, 105, 110, 103, 69, 118, 101, 110, 116, -13, -14, -71, 35, 116, 11, -75, 63, 3, 0, 10, 90, 0, 21, 109, 100, 99, 67, 111, 112, 121, 76, 111, 111, 107, 117, 112, 82, 101, 113, 117, 105, 114, 101, 100, 90, 0, 17, 110, 100, 99, 76, 111, 111, 107, 117, 112, 82, 101, 113, 117, 105, 114, 101, 100, 74, 0, 9, 116, 105, 109, 101, 83, 116, 97, 109, 112, 76, 0, 12, 99, 97, 116, 101, 103, 111, 114, 121, 78, 97, 109, 101, 116, 0, 18, 76, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 83, 116, 114, 105, 110, 103, 59, 76, 0, 12, 108, 111, 99, 97, 116, 105, 111, 110, 73, 110, 102, 111, 116, 0, 35, 76, 111, 114, 103, 47, 97, 112, 97, 99, 104, 101, 47, 108, 111, 103, 52, 106, 47, 115, 112, 105, 47, 76, 111, 99, 97, 116, 105, 111, 110, 73, 110, 102, 111, 59, 76, 0, 7, 109, 100, 99, 67, 111, 112, 121, 116, 0, 21, 76, 106, 97, 118, 97, 47, 117, 116, 105, 108, 47, 72, 97, 115, 104, 116, 97, 98, 108, 101, 59, 76, 0, 3, 110, 100, 99, 113, 0, 126, 0, 1, 76, 0, 15, 114, 101, 110, 100, 101, 114, 101, 100, 77, 101, 115, 115, 97, 103, 101, 113, 0, 126, 0, 1, 76, 0, 10, 116, 104, 114, 101, 97, 100, 78, 97, 109, 101, 113, 0, 126, 0, 1, 76, 0, 13, 116, 104, 114, 111, 119, 97, 98, 108, 101, 73, 110, 102, 111, 116, 0, 43, 76, 111, 114, 103, 47, 97, 112, 97, 99, 104, 101, 47, 108, 111, 103, 52, 106, 47, 115, 112, 105, 47, 84, 104, 114, 111, 119, 97, 98, 108, 101, 73, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 59, 120, 112, 0, 0};
    private byte[] seg2 = new byte[]{112, 112, 112, 116};
    private byte[] renderedMessage;
    private byte[] ref = new byte[]{116};
    private byte[] seg3 = new byte[]{112, 119, 4};
    private byte[] seg4 = new byte[]{112, 120, 121};
    private String host;
    private int port;

    public CLDCLoggingEvent(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void log(String message, String loggerName, int level) {
        this.renderedMessage = this.getLenAndBytes(message);
        byte[] threadName = this.getLenAndBytes(Thread.currentThread().toString());
        byte[] curTime = this.long2byte(System.currentTimeMillis());
        byte[] categoryName = this.getLenAndBytes(loggerName);
        byte[] lev = this.int2byte(level * 10000);
        byte[] totalmessage = this.append(this.append(this.append(this.append(this.append(this.append(this.append(this.append(this.append(this.append(this.seg1, curTime), this.ref), categoryName), this.seg2), this.renderedMessage), this.ref), threadName), this.seg3), lev), this.seg4);
        SocketLogger sl = new SocketLogger();
        sl.open();
        sl.transmit(totalmessage);
    }

    private byte[] append(byte[] pre, byte[] app) {
        int len = pre.length + app.length;
        byte[] res = new byte[len];
        System.arraycopy(pre, 0, res, 0, pre.length);
        System.arraycopy(app, 0, res, pre.length, app.length);
        return res;
    }

    private byte[] getLenAndBytes(String s) {
        byte[] sb = s.getBytes();
        int l = sb.length;
        byte[] lb = new byte[]{(byte)(l >>> 8 & 0xFF), (byte)(l & 0xFF)};
        byte[] res = new byte[l + 2];
        System.arraycopy(lb, 0, res, 0, 2);
        System.arraycopy(sb, 0, res, 2, l);
        return res;
    }

    private byte[] int2byte(int i) {
        byte[] b = new byte[]{(byte)(i >>> 24 & 0xFF), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
        return b;
    }

    private byte[] long2byte(long l) {
        byte[] b = new byte[]{(byte)(l >>> 56 & 0xFFL), (byte)(l >>> 48 & 0xFFL), (byte)(l >>> 40 & 0xFFL), (byte)(l >>> 32 & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l & 0xFFL)};
        return b;
    }

    private class SocketLogger {
        StreamConnection conn = null;
        OutputStream out = null;

        private SocketLogger() {
        }

        void open() {
            try {
                this.conn = (StreamConnection)Connector.open((String)("socket://" + CLDCLoggingEvent.this.host + ":" + CLDCLoggingEvent.this.port));
                this.out = this.conn.openOutputStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        void transmit(byte[] mesg) {
            try {
                this.out.write(mesg);
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

