/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.io.IOException;
import org.coos.actorframe.application.Container;
import org.coos.actorframe.application.Session;
import org.coos.actorframe.threadpool.ThreadPool;
import org.coos.actorframe.threadpool.ThreadPoolRunnable;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.Schedulable;
import org.coos.javaframe.Scheduler;
import org.coos.javaframe.SchedulerData;
import org.coos.javaframe.SchedulerImpl;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.TraceObject;
import org.coos.javaframe.messages.ActorMsg;
import org.coos.javaframe.messages.Message;
import org.coos.util.serialize.AFClassLoader;

public class ThreadPooledScheduler
extends SchedulerImpl {
    private ThreadPool tp = null;

    protected void processMessage(ActorMsg msg, Schedulable sm) {
        Worker worker = new Worker(sm, msg);
        this.tp.runRunnable(worker);
    }

    public void setThreads(int threads) {
        super.setThreads(threads);
    }

    public synchronized void start() {
        this.tp = new ThreadPool(this.getName(), this.getThreads());
        super.start();
    }

    private class Worker
    implements Scheduler,
    ThreadPoolRunnable {
        private Schedulable sm;
        private ActorMsg msg;
        private TraceObject trace;

        public Worker(Schedulable sm, ActorMsg msg) {
            this.sm = sm;
            this.msg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Schedulable schedulable = this.sm;
            synchronized (schedulable) {
                this.sm.setScheduler(this);
                this.sm.processMessage(this.msg);
                if (this.sm.isReadyToBeDeleted()) {
                    this.remove(this.sm.getMyActorAddress());
                    if (this.isTraceOn()) {
                        SchedulerImpl.logger.log(2, "execute: ActorStateMachine deleted: " + this.sm);
                    }
                }
            }
        }

        public TraceObject getTraceObject() {
            return this.trace;
        }

        public void addRouter(Session domainSession) {
            ThreadPooledScheduler.this.addRouter(domainSession);
        }

        public void addSchedulable(Schedulable schedulable, ActorAddress adr) {
            ThreadPooledScheduler.this.addSchedulable(schedulable, adr);
        }

        public void addStateMachine(StateMachine sm, String type) {
            ThreadPooledScheduler.this.addStateMachine(sm, type);
        }

        public void clearLastMsgFromRouter() {
            ThreadPooledScheduler.this.clearLastMsgFromRouter();
        }

        public StateMachine createActor(ActorMsg sig, Schedulable curfsm) {
            return ThreadPooledScheduler.this.createActor(sig, curfsm);
        }

        public void destroyApp() {
            ThreadPooledScheduler.this.destroyApp();
        }

        public AFClassLoader getClassLoader() {
            return ThreadPooledScheduler.this.getClassLoader();
        }

        public String getName() {
            return ThreadPooledScheduler.this.getName();
        }

        public SchedulerData getSchedulerData() {
            return ThreadPooledScheduler.this.getSchedulerData();
        }

        public void interrupt() {
            ThreadPooledScheduler.this.interrupt();
        }

        public void output(ActorMsg sig, Schedulable schedulable) {
            ThreadPooledScheduler.this.output(sig, schedulable);
        }

        public void postMessageToScheduler(Message message, Schedulable schedulable) throws IOException {
            ThreadPooledScheduler.this.postMessageToScheduler(message, schedulable);
        }

        public void remove(ActorAddress actorAddress) {
            ThreadPooledScheduler.this.remove(actorAddress);
        }

        public void removeRouter() {
            ThreadPooledScheduler.this.removeRouter();
        }

        public void setStopFlag() {
            ThreadPooledScheduler.this.setStopFlag();
        }

        public void unRegVisibleActor(ActorAddress address) {
            ThreadPooledScheduler.this.unRegVisibleActor(address);
        }

        public void upDateVisibleActors(StateMachine curfsm) {
            ThreadPooledScheduler.this.upDateVisibleActors(curfsm);
        }

        public boolean isTraceError() {
            return ThreadPooledScheduler.this.isTraceError();
        }

        public boolean isTraceOn() {
            return ThreadPooledScheduler.this.isTraceOn();
        }

        public void setTrace(boolean on) {
            ThreadPooledScheduler.this.setTrace(on);
        }

        public void setTraceError(boolean on) {
            ThreadPooledScheduler.this.setTraceError(on);
        }

        public void configure(String s) {
            ThreadPooledScheduler.this.configure(s);
        }

        public void setClassLoader(Container container) {
            ThreadPooledScheduler.this.setClassLoader(container);
        }

        public void setName(String id) {
            ThreadPooledScheduler.this.setName(id);
        }

        public void setSchedulerData(SchedulerData schedulerData) {
            ThreadPooledScheduler.this.setSchedulerData(schedulerData);
        }

        public void setThreads(int threads) {
            ThreadPooledScheduler.this.setThreads(threads);
        }

        public void start() {
            ThreadPooledScheduler.this.start();
        }

        public void setTraceObject(TraceObject trace) {
            this.trace = trace;
        }

        public void notifyScheduler() {
            ThreadPooledScheduler.this.notifyScheduler();
        }
    }
}

