/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe.messages;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.messages.ActorMsg;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.HashtableHelper;
import org.coos.util.serialize.StringHelper;

public class AFPropertyMsg
extends ActorMsg {
    public String msgId;
    public Hashtable property;
    private Object o;

    public AFPropertyMsg() {
    }

    public String getMsgId() {
        return this.msgId;
    }

    public AFPropertyMsg(ActorMsg am, String msgId) {
        this.setSenderRole(am.getSenderRole());
        this.setReceiverRole(am.getReceiverRole());
        this.msgId = msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
        this.frameworkMsg = false;
    }

    public void setProperties(Hashtable properties) {
        this.property = properties;
    }

    public AFPropertyMsg(String msgId) {
        this.msgId = msgId;
    }

    public AFPropertyMsg(String msgId, boolean frameWorkMsg) {
        this.frameworkMsg = frameWorkMsg;
        this.msgId = msgId;
    }

    public AFPropertyMsg(String msgId, ActorAddress receiver, ActorAddress sender) {
        this.msgId = msgId;
        this.setReceiverRole(receiver);
        this.setSenderRole(sender);
    }

    public AFPropertyMsg(String msgId, String receiver, String sender) {
        this.msgId = msgId;
        this.setReceiverRole(new ActorAddress(receiver));
        this.setSenderRole(new ActorAddress(sender));
    }

    public Hashtable getProperty() {
        return this.property;
    }

    public Object getProperty(String name) {
        if (this.property == null) {
            return null;
        }
        this.o = this.property.get(name);
        return this.o;
    }

    public String getString(String name, String defaultValue) {
        if (this.property == null) {
            return defaultValue;
        }
        this.o = this.property.get(name);
        if (this.o == null) {
            return defaultValue;
        }
        return (String)this.o;
    }

    public String getString(String name) {
        if (this.property == null) {
            return null;
        }
        this.o = this.property.get(name);
        return (String)this.o;
    }

    public ActorAddress getActorAddress(String name) {
        if (this.property == null) {
            return null;
        }
        this.o = this.property.get(name);
        if (this.o == null) {
            return null;
        }
        return (ActorAddress)this.o;
    }

    public Vector getVector(String name) {
        if (this.property == null) {
            return null;
        }
        this.o = this.property.get(name);
        if (this.o == null) {
            return null;
        }
        return (Vector)this.o;
    }

    public int getInt(String name) {
        if (this.property == null) {
            return 0;
        }
        this.o = this.property.get(name);
        if (this.o == null) {
            return 0;
        }
        return (Integer)this.o;
    }

    public int getInt(String name, int defaultValue) {
        if (this.property == null) {
            return defaultValue;
        }
        this.o = this.property.get(name);
        if (this.o == null) {
            return defaultValue;
        }
        return (Integer)this.o;
    }

    public boolean getBoolean(String name) {
        if (this.property == null) {
            return false;
        }
        this.o = this.property.get(name);
        if (this.o == null) {
            return false;
        }
        return (Boolean)this.o;
    }

    public AFPropertyMsg setByteArray(String name, byte[] array) {
        if (this.property == null) {
            this.property = new Hashtable();
        }
        this.property.put(name, array);
        return this;
    }

    public byte[] getByteArray(String name) {
        if (this.property == null) {
            return null;
        }
        this.o = this.property.get(name);
        if (this.o == null) {
            return null;
        }
        return (byte[])this.o;
    }

    public AFPropertyMsg setDouble(String name, double value) {
        if (this.property == null) {
            this.property = new Hashtable();
        }
        this.property.put(name, new Double(value));
        return this;
    }

    public double getDouble(String name) {
        if (this.property == null) {
            return 0.0;
        }
        this.o = this.property.get(name);
        if (this.o == null) {
            return 0.0;
        }
        return (Double)this.o;
    }

    public AFPropertyMsg setFloat(String name, float value) {
        if (this.property == null) {
            this.property = new Hashtable();
        }
        this.property.put(name, new Float(value));
        return this;
    }

    public float getFloat(String name) {
        if (this.property == null) {
            return 0.0f;
        }
        this.o = this.property.get(name);
        if (this.o == null) {
            return 0.0f;
        }
        return ((Float)this.o).floatValue();
    }

    public AFPropertyMsg setLong(String name, long value) {
        if (this.property == null) {
            this.property = new Hashtable();
        }
        this.property.put(name, new Long(value));
        return this;
    }

    public long getLong(String name) {
        if (this.property == null) {
            return 0L;
        }
        this.o = this.property.get(name);
        if (this.o == null) {
            return 0L;
        }
        return (Long)this.o;
    }

    public long getLong(String name, long defaultValue) {
        if (this.property == null) {
            return defaultValue;
        }
        this.o = this.property.get(name);
        if (this.o == null) {
            return defaultValue;
        }
        return (Long)this.o;
    }

    public AFPropertyMsg setProperty(String name, Object value) {
        if (value == null) {
            this.removeProperty(name);
            return this;
        }
        if (this.property == null) {
            this.property = new Hashtable();
        }
        this.property.put(name, value);
        return this;
    }

    public AFPropertyMsg setBoolean(String name, boolean value) {
        if (this.property == null) {
            this.property = new Hashtable();
        }
        this.property.put(name, new Boolean(value));
        return this;
    }

    public AFPropertyMsg setInt(String name, int value) {
        if (this.property == null) {
            this.property = new Hashtable();
        }
        this.property.put(name, new Integer(value));
        return this;
    }

    public String getSignalName() {
        return this.msgId;
    }

    public boolean hasProperty(String propertyName) {
        return this.property.containsKey(propertyName);
    }

    public boolean equals(Object o) {
        if (o instanceof AFPropertyMsg) {
            return ((AFPropertyMsg)o).msgId.equals(this.msgId);
        }
        if (o instanceof String) {
            return o.equals(this.msgId);
        }
        return false;
    }

    public AFPropertyMsg cloneAFPropertyMsg(AFClassLoader cl) {
        return (AFPropertyMsg)super.cloneMsg(cl);
    }

    public String messageContent() {
        StringBuffer sb = new StringBuffer();
        sb.append("MsgId: " + this.msgId);
        if (this.property != null) {
            Enumeration en = this.property.keys();
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                sb.append(" " + s + ": " + this.property.get(s) + " : ");
            }
        }
        return super.messageContent() + sb;
    }

    public String toString() {
        return super.toString() + ", MSG_ID: " + this.msgId;
    }

    public AFPropertyMsg(InputStream is, AFClassLoader cl) throws IOException {
        DataInputStream din = new DataInputStream(is);
        super.readInput(din, null);
        if (this.getMsgType() != 1) {
            this.msgId = StringHelper.resurrect((DataInputStream)din);
            this.property = HashtableHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        ((OutputStream)dout).write(super.serialize());
        if (this.getMsgType() != 1) {
            ((OutputStream)dout).write(StringHelper.persist((String)this.msgId));
            ((OutputStream)dout).write(HashtableHelper.persist((Hashtable)this.property));
        }
        dout.flush();
        return bout.toByteArray();
    }

    public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
        ByteArrayInputStream bin = super.deSerialize(data, cl);
        DataInputStream din = new DataInputStream(bin);
        if (this.getMsgType() != 1) {
            this.msgId = StringHelper.resurrect((DataInputStream)din);
            this.property = HashtableHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        }
        return bin;
    }

    public Object removeProperty(String name) {
        if (this.property != null) {
            return this.property.remove(name);
        }
        return null;
    }
}

