/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.actorframe.application;

import org.coos.javaframe.messages.Message;
import org.coos.actorframe.application.SessionManager;

/**
 * 
 * @author Geir Melby, Tellu AS
 */
public interface RouterReceiver {

	/**
	 * Process receing messsages from Sessions. The ActorRouter needs the
	 * reference to input mailbox to the this sessions TCP Writer
	 * 
	 * @param msg
	 *            is the message to be send
	 * @param sessionManager
	 *            reference to the Writers input mail box
	 * @param sessionName
	 */
	public void processMessage(Message msg, SessionManager sessionManager, String sessionName);

	/**
	 * Force this router to send an update to it's clients. Used i.e. when a new
	 * connection has been opened so that the new client receives this routers
	 * routing info.
	 */
	public void updateRouter();

	public void sessionError(SessionManager sessionManager, String sessionName, String reason);
}
