/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.actorframe.threadpool;

import java.util.Vector;

/**
 * 
 * @author Knut Eilif Husa, Tellu AS
 */

public class Queue {
	private Vector vec = new Vector();

	synchronized public void put(Object o) {
		// Add the element
		vec.addElement(o);

		// There might be threads waiting for the new object --
		// give them a chance to get it
		notifyAll();
	}

	synchronized public Object get() {
		while (true) {
			if (vec.size() > 0) {
				// There's an available object!
				Object o = vec.elementAt(0);

				// Remove it from our internal list, so someone else
				// doesn't get it.
				vec.removeElementAt(0);

				// Return the object
				return o;
			} else {
				// There aren't any objects available. Do a wait(),
				// and when we wake up, check again to see if there
				// are any.
				try {
					wait();
				} catch (InterruptedException ie) {
				}
			}
		}
	}
}
