/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.actorframe.threadpool;

import org.coos.javaframe.TraceObject;

/**
 * 
 * @author Knut Eilif Husa, Tellu AS
 */
public class ThreadPoolThread implements Runnable {
	private ThreadPool tp;
	private boolean active = false;
	private TraceObject trace = new TraceObject();

	ThreadPoolThread(ThreadPool tp, int num) {
		this.tp = tp;
		new Thread(this, tp.name + "-" + num).start();
	}

	public void run() {
		while (true) {
			try {
				// Get the next task from the parent ThreadPool
				ThreadPoolRunnable r = tp.getRunnable();
				// Make it use this threads trace object
				r.setTraceObject(trace);
				// Run the task!
				active = true;
				r.run();
				active = false;
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public boolean active() {
		return active;
	}
}
