/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

import java.io.DataInputStream;
import java.io.IOException;

/**
 * 
 * @author Geir Melby, Tellu AS
 */
public class RouterAddress extends ActorAddress {
	public RouterAddress() {
		super();
	}

	public RouterAddress(String actorID, String actorType) {
		super(actorID, actorType);
	}

	public RouterAddress(DataInputStream din) throws IOException {
		super(din);
	}

	/**
	 * The constructor formes the Address as a concatenation of the two input
	 * parameters
	 * 
	 * @param actorID
	 *            The ID of an actor
	 * @param actorType
	 *            The Type of an actor
	 */
	public RouterAddress(String actorID, String actorType, String protocol) {
		super(actorID, actorType);
		setProtocol(protocol);
	}

	/**
	 * Creates an actor address with an known IP address
	 * 
	 * @param actorID
	 *            The ID of an actor
	 * @param actorType
	 *            The Type of an actor
	 * @param actorIpAddr
	 *            is the IP address of the receiver of the message
	 */
	public RouterAddress(String actorID, String actorType, String actorIpAddr, String actorPort, String protocol) {
		super(actorID, actorType, actorIpAddr, actorPort, protocol);
	}
}
