/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorMsg;

/**
 * 
 * @author Geir Melby, Tellu AS
 * 
 * 
 * 
 */
public class TestScheduler extends SchedulerImpl {
	private boolean printing = true;

	// SchedulerData schedulerData;
	/**
	 * The constructor
	 */
	public TestScheduler(SchedulerData schedulerData) {
		setSchedulerData(schedulerData);

		if (getSchedulerData().getDefaultScheduler() == null) {
			getSchedulerData().setDefaultScheduler(this);
		}
	}

	public boolean isPrinting() {
		return printing;
	}

	public void setPrinting(boolean printing) {
		this.printing = printing;
	}

	public boolean output(ActorMsg sig, Schedulable curfsm) {
		String msgId;

		if (sig instanceof AFPropertyMsg) {
			msgId = ((AFPropertyMsg) sig).getMsgId();
		} else {
			msgId = sig.getSignalName();
		}

		if (isPrinting()) {
			System.out.println("Output received: " + msgId);
		}

		if (curfsm != null) {
			if (curfsm.getScheduler().isTraceOn()) {
				curfsm.getScheduler().getTraceObject().traceOutput(sig);
			}
		}
        return true;
    }

	/**
	 * Sends an Actor Reg message to the local router, to update the router with
	 * visble actors
	 * 
	 * @param sm
	 *            is the actor
	 */
	public void upDateVisibleActors(StateMachine sm) {
		if (isPrinting()) {
			System.out.println("TestScheduler.upDateVisibleActors: SM:" + sm.getMyActorAddress());
		}
	}

	/**
	 * Sends an Actor Reg message to the local router, to update the router with
	 * visble actors
	 * 
	 * @param aa
	 *            is the actor
	 */
	public void unRegVisibleActor(ActorAddress aa) {
		if (isPrinting()) {
			System.out.println("TestScheduler.unRegVisibleActor: SM:" + aa);
		}
	}

	/**
	 * Cheks if the statemachine that is equal to the actor address
	 * 
	 * @param aa
	 *            the actor address of the state machine to be checked
	 * @return true if the state machine exists
	 */
	public boolean containsStateMachine(ActorAddress aa) {
		return true;
	}
}
