/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

import org.coos.javaframe.messages.ActorMsg;

/**
 * 
 * @author Geir Melby, Tellu AS
 * 
 * 
 * 
 */
public interface TraceInterface {
	void traceTask(String str);

	// void traceSystem(int level, String str);
	void traceSystem(String str);

	void traceOutput(ActorMsg am);

	void traceWarning(String s);

	void traceOut(int level, String value);

	void traceOut(int level, int categories, String value);

	void traceInit(StateMachine curfsm);

	public void setActor(ActorAddress actor);

	public void setInputSignal(ActorMsg inputSignal);

	public void setCurrentState(String currentState);

	public void setNewState(String newState);

	public String getTraceHeader();

	public void setTrace(boolean trace);
}
