/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.util.Date;
import org.coos.javaframe.Logger;
import org.coos.javaframe.LoggerFactory;

public class BasicLoggerImpl
implements Logger {
    String loggername;
    int traceLevel;
    static Date date;

    public BasicLoggerImpl(String loggername) {
        this.loggername = loggername;
        System.out.println("Default logger: " + loggername + " is initiated");
    }

    public BasicLoggerImpl() {
        System.out.println("BasicLoggerImpl is used");
    }

    public void log(int level, int categories, String value) {
        switch (level) {
            case 4: {
                System.err.println(BasicLoggerImpl.getTimeString() + " ERROR " + this.loggername + " " + value);
                break;
            }
            case 5: {
                System.err.println(BasicLoggerImpl.getTimeString() + " FATAL " + this.loggername + " " + value);
                break;
            }
            case 3: {
                System.out.println(BasicLoggerImpl.getTimeString() + " WARN " + this.loggername + " " + value);
                break;
            }
            case 2: {
                System.out.println(BasicLoggerImpl.getTimeString() + " INFO " + this.loggername + " " + value);
                break;
            }
            case 1: {
                System.out.println(BasicLoggerImpl.getTimeString() + " DEBUG " + this.loggername + " " + value);
            }
        }
    }

    private static String getTimeString() {
        return new Date(System.currentTimeMillis()).toString();
    }

    public void log(int level, String value) {
        this.log(this.traceLevel, -1, value);
    }

    public String getLoggerName() {
        return this.loggername;
    }

    public void setLoggerName(String loggerName) {
        this.loggername = loggerName;
    }

    public void setTraceLevel(int traceLevel) {
        this.traceLevel = traceLevel;
    }

    public boolean isDebugEnabled() {
        return LoggerFactory.isTraceOn() && this.traceLevel >= 1;
    }

    public boolean isErrorEnabled() {
        return LoggerFactory.isTraceOn() && this.traceLevel >= 4;
    }

    public boolean isInfoEnabled() {
        return LoggerFactory.isTraceOn() && this.traceLevel >= 2;
    }

    public boolean isTraceEnabled() {
        return LoggerFactory.isTraceOn() && this.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return LoggerFactory.isTraceOn() && this.traceLevel >= 3;
    }
}

