/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

public class TraceConstants {
    public static final int ctSetCategory = 1;
    public static final int ctSetLevel = 2;
    public static final int tcOff = 0;
    public static final int tcAllOn = -1;
    public static final int tcTask = 1;
    public static final int tcSystem = 2;
    public static final int tcTransition = 4;
    public static final int tcSendMsg = 8;
    public static final int tcFramework = 16;
    public static final int tcTraceDiagram = 32;
    public static final int tcUser1 = 256;
    public static final int tcUser2 = 512;
    public static final int tcUser3 = 768;
    public static final int tcUser4 = 1024;
    public static final int tlDebug = 1;
    public static final int tlInfo = 2;
    public static final int tlWarn = 3;
    public static final int tlError = 4;
    public static final int tlFatal = 5;
    public static final String Off = "off";
    public static final String AllOn = "allOn";
    public static final String Task = "task";
    public static final String System = "System";
    public static final String Transition = "transition";
    public static final String SendMsg = "SendMsg";
    public static final String FrameWork = "FrameWork";
    public static final String TraceDiagram = "TraceDiagram";
    public static final String Debug = "Debug";
    public static final String Info = "Info";
    public static final String Warn = "Warn";
    public static final String Error = "Error";
    public static final String Fatal = "Fatal";
    public static final String SetCategory = "SetCategory";
    public static final String SetLevel = "SetLevel";

    public static int getCommandType(String commandType) {
        int value = 0;
        if (commandType.equals(SetLevel)) {
            value = 2;
        }
        if (commandType.equals(SetCategory)) {
            value = 1;
        }
        return value;
    }

    public static int getTraceCategories(String traceCategories) {
        int value = -1;
        if (traceCategories.equalsIgnoreCase(Off)) {
            value = 0;
        } else if (traceCategories.equalsIgnoreCase(AllOn)) {
            value = -1;
        } else if (traceCategories.equalsIgnoreCase(System)) {
            value = 2;
        } else if (traceCategories.equalsIgnoreCase(Transition)) {
            value = 4;
        } else if (traceCategories.equalsIgnoreCase(FrameWork)) {
            value = 16;
        } else if (traceCategories.equalsIgnoreCase(SendMsg)) {
            value = 8;
        } else if (traceCategories.equalsIgnoreCase(TraceDiagram)) {
            value = 32;
        }
        return value;
    }

    public static int getTraceLevel(String traceLevel) {
        int value = 1;
        if (traceLevel.equalsIgnoreCase(Debug)) {
            value = 1;
        }
        if (traceLevel.equalsIgnoreCase(Info)) {
            value = 2;
        }
        if (traceLevel.equalsIgnoreCase(Fatal)) {
            value = 5;
        }
        if (traceLevel.equalsIgnoreCase(Error)) {
            value = 4;
        }
        if (traceLevel.equalsIgnoreCase(Warn)) {
            value = 3;
        }
        return value;
    }

    public static String getTraceCategories(int traceCategories) {
        String value = "";
        if (traceCategories == 0) {
            return Off;
        }
        if (traceCategories == -1) {
            return AllOn;
        }
        if ((traceCategories & 2) != 0) {
            return System;
        }
        if ((traceCategories & 4) != 0) {
            return Transition;
        }
        if ((traceCategories & 8) != 0) {
            return SendMsg;
        }
        if ((traceCategories & 0x10) != 0) {
            return FrameWork;
        }
        if ((traceCategories & 0x20) != 0) {
            return TraceDiagram;
        }
        return value;
    }

    public static String getCommandType(int commandType) {
        String value = "";
        if (commandType == 2) {
            value = SetLevel;
        }
        if (commandType == 1) {
            value = SetCategory;
        }
        return value;
    }

    public static String getTraceLevel(int traceLevel) {
        String value = "";
        if (traceLevel == 1) {
            value = Debug;
        }
        if (traceLevel == 2) {
            value = Info;
        }
        if (traceLevel == 5) {
            value = Fatal;
        }
        if (traceLevel == 4) {
            value = Error;
        }
        if (traceLevel == 3) {
            value = Warn;
        }
        return value;
    }
}

