/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.actorframe.application;

import org.coos.util.serialize.AFClassLoader;

/**
 * @author Geir Melby, Tellu AS
 */
public interface Container extends AFClassLoader {

	// The name that the bundle context will be registered with in case of a
	// OSGI Container
	public static final String BUNDLE_CONTEXT = "BundleContext";
	// The name that the ENDPOINT will be registered with
	public static final String ENDPOINT = "Endpoint";

	// public ActorRouterI getMessageBus();

	public Session createMessageBusAdapter(String sessionName);

	public void init();

	public void start();

	public void suspend();

	public void resume();

	public void exit();

	/**
	 * This method retrieves Objects from the Container. Typically it can be
	 * environment resources that the Container provides, such as the bundle
	 * context in case of an OSGI environment
	 * 
	 * @param name
	 *            - the name of the object
	 * @return the Object
	 */
	public Object getObject(String name);

	public boolean startRouter();

	public boolean stopRouter();

	public boolean isRouterRunning();

	public boolean isRouterConnected();

	/**
	 * Catch exception and optionally show it
	 * 
	 * @param e
	 */
	public void displayError(Exception e);

    public byte[] getMacAddress();
}
