/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe.messages;

import org.coos.util.serialize.AFClassLoader;
import org.coos.javaframe.messages.ActorMsg;
import org.coos.util.serialize.StringHelper;
import org.coos.util.serialize.VectorHelper;
import org.coos.javaframe.messages.RouterManagementMsg;

import java.io.*;
import java.util.Vector;

/**
 * 
 * @author Geir Melby, Tellu AS
 */
public class ActorRouterRegMsg extends RouterManagementMsg {

	public static String SENDER_TYPE_ACTOR = "A";
	public static String SENDER_TYPE_CLIENT = "C";
	public static String SENDER_TYPE_SERVER = "S";

	public Vector actors;
	public int legCount;
	public String senderType;

	public ActorRouterRegMsg() {
	}

	public ActorRouterRegMsg(Vector actors, int legCount) {
		this.actors = actors;
		this.legCount = legCount;
		this.senderType = SENDER_TYPE_ACTOR;
	}

	public ActorRouterRegMsg(Vector actors, int legCount, String senderType) {
		this.actors = actors;
		this.legCount = legCount;
		this.senderType = senderType;
	}

	public ActorRouterRegMsg(ActorMsg am) {
		super(am);
	}

	public Vector getActors() {
		return actors;
	}

	public void setActors(Vector actors) {
		this.actors = actors;
	}

	public int getLegCount() {
		return legCount;
	}

	public void setLegCount(int legCount) {
		this.legCount = legCount;
	}

	public String messageContent() {
		return super.messageContent() + "Reg actors: " + actors;
	}

	/**
	 * This function must implement the serialization of the object.
	 * 
	 * @return a byte array with the objects data
	 * @throws java.io.IOException
	 */
	public byte[] serialize() throws IOException {
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		DataOutputStream dout = new DataOutputStream(bout);
		dout.write(super.serialize());
		dout.write(VectorHelper.persist(actors));
		dout.writeInt(legCount);
		dout.write(StringHelper.persist(senderType));
		dout.flush();
		return bout.toByteArray();
	}

	/**
	 * Use this function for resurrection of the object
	 * 
	 * @param data
	 *            The serialized data containing the object data
	 * @throws java.io.IOException
	 */
	public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
		ByteArrayInputStream bin = super.deSerialize(data, cl);
		DataInputStream din = new DataInputStream(bin);
		actors = VectorHelper.resurrect(din, cl);
		legCount = din.readInt();
		senderType = StringHelper.resurrect(din);
		return bin;
	}
}