/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe.messages;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

import org.coos.javaframe.ActorAddress;
import org.coos.util.serialize.AFClassLoader;

public class OptimizedMsg extends ActorMsg {
	public static ActorAddress receiveAddress;
	public static ActorAddress sendAddress;
	public Vector content = new Vector();
	public byte classId;
	private static final int BYTE = 0;
	private static final int SHORT = 1;
	private static final int INTEGER = 2;
	private static final int LONG = 3;
	private static final int FLOAT = 4;
	private static final int STRING = 5;
	private static final int BOOLEAN = 6;

	/**
     *
     */
	public OptimizedMsg() {
		super();
	}

	/**
	 * @param aa
	 * @param replyStack
	 */
	public OptimizedMsg(ActorAddress aa, Vector replyStack) {
		super(aa);

		// TODO Auto-generated constructor stub
	}

	/**
	 * @param aa
	 */
	public OptimizedMsg(ActorAddress aa) {
		super(aa);

		// TODO Auto-generated constructor stub
	}

	/**
	 * @param am
	 */
	public OptimizedMsg(ActorMsg am) {
		super(am);

		// TODO Auto-generated constructor stub
	}

	public OptimizedMsg(byte classId) {
		super();
		this.classId = classId;
	}

	public byte[] serialize() throws IOException {
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		DataOutputStream dout = new DataOutputStream(bout);

		dout.writeByte(classId);
		dout.writeByte(content.size());

		for (int i = 0; i < content.size(); i++) {
			Object o = content.elementAt(i);

			if (o instanceof Integer) {
				dout.writeByte(INTEGER);
				dout.writeInt(((Integer) o).intValue());
			} else if (o instanceof Byte) {
				dout.writeByte(BYTE);
				dout.writeByte(((Byte) o).byteValue());
			} else if (o instanceof Short) {
				dout.writeByte(SHORT);
				dout.writeShort(((Short) o).shortValue());
			} else if (o instanceof String) {
				dout.writeByte(STRING);
				dout.writeUTF((String) o);
			} else if (o instanceof Long) {
				dout.writeByte(LONG);
				dout.writeLong(((Long) o).longValue());
			} else if (o instanceof Float) {
				dout.writeByte(FLOAT);
				dout.writeFloat(((Float) o).floatValue());
			} else if (o instanceof Boolean) {
				dout.writeByte(BOOLEAN);
				dout.writeBoolean(((Boolean) o).booleanValue());
			} else {
				throw new IOException("Cannot persist " + "object of type " + o.getClass().getName());
			}
		}

		dout.flush();

		return bout.toByteArray();
	}

	public String messageContent() {
		return super.messageContent() + " Optimized classid: " + classId + " content: " + content + " receiver: "
				+ super.getReceiverRole() + " senderAddress: " + super.getSenderRole();
	}

	/**
	 * Use this function for resurrection of the object
	 * 
	 * @param data
	 *            The serialized data containing the object data
	 * @throws java.io.IOException
	 */
	public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
		ByteArrayInputStream bin = new ByteArrayInputStream(data);
		DataInputStream din = new DataInputStream(bin);

		content = new Vector();
		classId = din.readByte();

		byte contentSize = din.readByte();

		for (int i = 0; i < contentSize; i++) {
			byte type = din.readByte();

			if (type == INTEGER) {
				content.addElement(new Integer(din.readInt()));
			} else if (type == BYTE) {
				content.addElement(new Byte(din.readByte()));
			} else if (type == SHORT) {
				content.addElement(new Short(din.readShort()));
			} else if (type == STRING) {
				content.addElement(din.readUTF());
			} else if (type == LONG) {
				content.addElement(new Long(din.readLong()));
			} else if (type == FLOAT) {
				content.addElement(new Float(din.readFloat()));
			} else if (type == BOOLEAN) {
				content.addElement(new Boolean(din.readBoolean()));
			} else {
				throw new IOException("Cannot read object of type " + type);
			}
		}

		if (super.getReceiverRole() == null)
			super.setReceiverRole(receiveAddress);

		if (super.getSenderRole() == null)
			super.setSenderRole(sendAddress);

		return bin;
	}
}
