/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.coos.javaframe.ConnectorSpec;
import org.coos.javaframe.PartSpec;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.AFSerializer;
import org.coos.util.serialize.HashtableHelper;

public class ActorPartSpec
extends PartSpec
implements AFSerializer {
    Hashtable actorProperties;

    public ActorPartSpec() {
        this.portConnectors = new Hashtable();
    }

    public ActorPartSpec(String[] roleNames, String roleType, int low, int high) {
        super(roleNames, roleType, low, high);
    }

    public ActorPartSpec(String[] roleNames, String roleType, int low, int high, Hashtable actorProperties) {
        super(roleNames, roleType, low, high);
        this.actorProperties = actorProperties;
    }

    public ActorPartSpec(String roleName, String roleType) {
        super(roleName, roleType, 1, 1);
    }

    public void setPortConnectors(Hashtable portConnectors) {
        this.portConnectors = portConnectors;
    }

    public String toString() {
        Vector<String> inst = new Vector<String>();
        if (this.roleNames != null) {
            for (int i = 0; i < this.roleNames.length; ++i) {
                inst.addElement(this.roleNames[i]);
            }
        }
        String s = "Part: " + this.roleType + " Min: " + this.low + " Max: " + this.high + " Instances: " + inst.toString();
        if (this.portConnectors != null) {
            s = s + " Ports: " + this.portConnectors.toString();
        }
        if (this.actorDomain != null) {
            s = s + " ActorDomain: " + this.actorDomain;
        }
        return s;
    }

    public String getPartDesc() {
        return this.getRoleType() + "(" + this.getLow() + "," + this.getHigh() + ")";
    }

    public Hashtable getPorts() {
        return this.portConnectors;
    }

    public Vector getClonedConnectors(String portName) {
        Vector<Object> retconns = new Vector<Object>();
        Vector conns = this.getConnectors(portName);
        if (conns == null) {
            return retconns;
        }
        Enumeration enumer = conns.elements();
        while (enumer.hasMoreElements()) {
            ConnectorSpec cs = (ConnectorSpec)enumer.nextElement();
            retconns.addElement(cs.clone());
        }
        return retconns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartSpec)) {
            return false;
        }
        ActorPartSpec part = (ActorPartSpec)o;
        return !(this.roleType != null ? !this.roleType.equals(part.roleType) : part.roleType != null);
    }

    public Vector getConnectors(String portName) {
        return this.portConnectors != null ? (Vector)this.portConnectors.get(portName) : new Vector();
    }

    public Vector findUpdatedParts(ActorPartSpec ps) {
        return new Vector();
    }

    public Vector getUpdatedPortNames(ActorPartSpec ps) {
        String key;
        Vector<String> changedPorts = new Vector<String>();
        Hashtable otherConn = ps.getPorts();
        if (otherConn == null) {
            return changedPorts;
        }
        Enumeration e1 = otherConn.keys();
        while (e1.hasMoreElements()) {
            String key2 = (String)e1.nextElement();
            if (this.portConnectors.containsKey(key2)) continue;
            changedPorts.addElement(key2);
        }
        Enumeration e2 = this.portConnectors.keys();
        while (e2.hasMoreElements()) {
            key = (String)e2.nextElement();
            if (otherConn.containsKey(key)) continue;
            changedPorts.addElement(key);
        }
        e2 = this.portConnectors.keys();
        block2: while (e2.hasMoreElements()) {
            key = (String)e2.nextElement();
            if (changedPorts.contains(key)) continue;
            Vector conn1 = (Vector)otherConn.get(key);
            Vector conn2 = this.getConnectors(key);
            if (conn1.size() != conn2.size()) {
                changedPorts.addElement(key);
                continue;
            }
            for (int i = 0; i < conn1.size(); ++i) {
                if (conn2.contains(conn1.elementAt(i))) continue;
                changedPorts.addElement(key);
                continue block2;
            }
        }
        return changedPorts;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        ((OutputStream)dout).write(super.serialize());
        ((OutputStream)dout).write(HashtableHelper.persist((Hashtable)this.portConnectors));
        ((OutputStream)dout).write(HashtableHelper.persist((Hashtable)this.actorProperties));
        dout.flush();
        return bout.toByteArray();
    }

    public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
        ByteArrayInputStream bin = super.deSerialize(data, cl);
        DataInputStream din = new DataInputStream(bin);
        this.portConnectors = HashtableHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.actorProperties = HashtableHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        return bin;
    }

    public Hashtable getActorProperties() {
        if (this.actorProperties == null) {
            this.actorProperties = new Hashtable();
        }
        return this.actorProperties;
    }

    public void setActorProperties(Hashtable actorProperties) {
        this.actorProperties = actorProperties;
    }
}

