/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe.application;

import java.util.Enumeration;
import java.util.Vector;
import org.coos.actorframe.application.AFServiceFactory;
import org.coos.actorframe.application.ActorRouterI;
import org.coos.actorframe.application.ApplicationConstants;
import org.coos.actorframe.application.Container;
import org.coos.actorframe.application.DomainSpec;
import org.coos.actorframe.application.Session;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.ActorFrameException;
import org.coos.javaframe.ApplicationSpec;
import org.coos.javaframe.Logger;
import org.coos.javaframe.LoggerFactory;
import org.coos.javaframe.SchedulableAdapter;
import org.coos.javaframe.Scheduler;
import org.coos.javaframe.SchedulerData;
import org.coos.javaframe.SchedulerSpec;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorMsg;
import org.coos.javaframe.messages.JFConstants;

public class Application
implements ApplicationConstants,
JFConstants {
    protected ApplicationSpec applicationSpec;
    protected static Logger logger = LoggerFactory.getLogger("org.coos.javaframe");
    protected static Application instance;
    protected SchedulerData schedulerData;
    protected Container container;
    protected int state;
    protected ActorRouterI actorRouter;

    public Application(ApplicationSpec appSpec) {
        this.setApplicationSpec(appSpec);
        instance = this;
    }

    public Application() {
        instance = this;
    }

    public final void initApplication() {
        this.state = 1;
        logger = LoggerFactory.getLogger(this.getClass().getName());
        this.extendInitApplication();
        if (this.applicationSpec == null) {
            logger.log(3, "Application: applicationSpec not set.");
            this.applicationSpec = this.readApplicationSpec();
        }
        this.state = 2;
    }

    public ActorRouterI getActorRouter() {
        return this.actorRouter;
    }

    public void setActorRouter(ActorRouterI actorRouter) {
        this.actorRouter = actorRouter;
    }

    public Logger getLogger() {
        return logger;
    }

    public void startApplication() {
        ActorAddress sender = this.getSenderAddress();
        if (this.getApplicationSpec() == null) {
            throw new NullPointerException("Application,startApplication: ApplicationSpec is null");
        }
        DomainSpec domainSpec = this.getApplicationSpec().getDomainSpec();
        if (domainSpec == null) {
            domainSpec = new DomainSpec("default", "ActorDomain");
            this.getApplicationSpec().setDomainSpec(domainSpec);
        }
        this.schedulerData = this.createDomain(domainSpec);
        this.schedulerData.getDefaultScheduler().addSchedulable(new SchedulableAdapter(sender){

            public boolean processMessage(ActorMsg sig) {
                if (sig.equals("RolePlayEndedMsg")) {
                    Application.this.applicationEnded();
                    if (this.getScheduler().isTraceOn()) {
                        logger.log(2, "ROLE_PLAY_ENDED_MSG: Application ended.");
                    }
                } else if (sig.equals("RoleCreateAckMsg")) {
                    if (this.getScheduler().isTraceOn()) {
                        logger.log(2, "ROLE_PLAY_ACK_MSG: Application created.");
                    }
                    Application.this.applictionActive();
                } else if (sig.equals("RoleCreateNackMsg")) {
                    if (this.getScheduler().isTraceOn()) {
                        logger.log(4, "ROLE_CREATE_NACK_MSG: Application start failed.");
                    }
                } else if (sig.equals("SuspendedMsg")) {
                    Application.this.applicationSuspended();
                } else if (sig.equals("ResumedMsg")) {
                    Application.this.applicationResumed();
                } else if (sig.equals("RoleUpdateAckMsg")) {
                    Application.this.applicationUpdated();
                } else {
                    Application.this.messageHandler(sig);
                }
                return true;
            }
        }, sender);
        this.addRouterSession();
        if (this.getApplicationSpec().autoStartRouter()) {
            this.getContainer().startRouter();
        }
        String actorId = this.schedulerData.getActorDomainName();
        String actorType = domainSpec.getActor();
        ActorAddress receiver = new ActorAddress(actorId, actorType);
        AFPropertyMsg msg = new AFPropertyMsg("RoleCreateMsg", true);
        msg.setReceiverRole(receiver);
        msg.setSenderRole(sender);
        msg.setBoolean("visible", true);
        msg.setInt("traceLevel", 3);
        this.getSchedulerData().getDefaultScheduler().output(msg, null);
    }

    public void restart() {
        AFPropertyMsg msg = new AFPropertyMsg("RoleRestartMsg", true);
        msg.setReceiverRole(new ActorAddress(this.schedulerData.getActorDomainName(), "ActorDomain"));
        this.schedulerData.getDefaultScheduler().output(msg, null);
    }

    public void setApplicationSpec(ApplicationSpec applicationSpec) {
        this.applicationSpec = applicationSpec;
    }

    protected SchedulerData createDomain(DomainSpec domainSpec) {
        if (this.container == null) {
            throw new NullPointerException("Container has not been initialized!");
        }
        if (domainSpec == null) {
            domainSpec = new DomainSpec("default", "ActorDomain");
        }
        String domainName = domainSpec.getDomainName();
        Application.setActorDomainName(domainName);
        SchedulerData schedulerData = new SchedulerData();
        schedulerData.setActorDomainName(domainName);
        Vector schedulerSpecs = domainSpec.getSchedulerSpecs();
        if (schedulerSpecs == null || schedulerSpecs.isEmpty()) {
            SchedulerSpec ss = new SchedulerSpec();
            ss.setId("default");
            domainSpec.addSchedulerSpec(ss);
        }
        logger.log(2, "Creation of scheduler starting");
        try {
            for (int k = 0; k < schedulerSpecs.size(); ++k) {
                SchedulerSpec schedulerSpec = (SchedulerSpec)schedulerSpecs.elementAt(k);
                Scheduler sched = (Scheduler)Class.forName(schedulerSpec.getClassName()).newInstance();
                sched.setThreads(schedulerSpec.getThreads());
                sched.setName(schedulerSpec.getId());
                Vector vs = schedulerSpec.getActorTypes();
                schedulerData.setDefaultScheduler(sched);
                sched.setSchedulerData(schedulerData);
                sched.setClassLoader(this.getContainer());
                StringBuffer sb = new StringBuffer("Scheduler " + sched.getName() + " is started. Actor types:  ");
                if (vs != null) {
                    for (int n = 0; n < vs.size(); ++n) {
                        String s = (String)vs.elementAt(n);
                        sb.append(s + " , ");
                        sched.configure(s);
                    }
                }
                sb.append(" Threads: " + schedulerSpec.getThreads());
                schedulerData.setContainer(this.getContainer());
                schedulerData.setApplicationSpec(this.getApplicationSpec());
                if (logger != null) {
                    logger.log(2, sb.toString());
                }
                sched.start();
            }
            schedulerData.getDefaultScheduler().setTrace(this.getApplicationSpec().isTraceEnabled());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        logger.log(1, "Creation of scheduler finished");
        return schedulerData;
    }

    public void addRouterSession() {
        try {
            String domainName = this.getApplicationSpec().getDomainSpec().getDomainName();
            Session domainSession = this.getContainer().createMessageBusAdapter(domainName);
            if (domainSession != null) {
                this.getSchedulerData().getDefaultScheduler().addRouter(domainSession);
            }
        }
        catch (ActorFrameException e) {
            return;
        }
    }

    public SchedulerData getSchedulerData() {
        return this.schedulerData;
    }

    protected StateMachine createClass(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (StateMachine)Class.forName(className).newInstance();
    }

    public void deleteApplication() {
        AFPropertyMsg msg = new AFPropertyMsg("RoleRemoveMsg", true);
        msg.setReceiverRole(new ActorAddress(this.schedulerData.getActorDomainName(), "ActorDomain"));
        this.schedulerData.getDefaultScheduler().output(msg, null);
    }

    public void resume() {
        this.resume(null);
    }

    public void resume(ActorAddress receiver) {
        this.state = 7;
        this.sendMessage((ActorMsg)new AFPropertyMsg("ResumeMsg", true), receiver);
    }

    public void suspend() {
        this.suspend(null);
    }

    public void suspend(ActorAddress receiver) {
        this.state = 4;
        this.sendMessage((ActorMsg)new AFPropertyMsg("SuspendMsg", true), receiver);
    }

    public void updateApplication() {
        this.state = 8;
        this.sendMessage((ActorMsg)new AFPropertyMsg("RoleUpdateMsg", true), "");
    }

    public void sendMessage(ActorMsg msg, String receiver) {
        this.sendMessage(msg, new ActorAddress(receiver));
    }

    public void sendMessage(ActorMsg msg, ActorAddress receiver) {
        if (receiver == null) {
            receiver = new ActorAddress("ActorDomain");
        }
        String domainName = this.schedulerData.getActorDomainName();
        if (receiver.getActorID() == null) {
            receiver.setActorID(domainName);
        }
        msg.setReceiverRole(receiver);
        msg.setSenderRole(this.getSenderAddress());
        this.schedulerData.getDefaultScheduler().output(msg, null);
    }

    protected ApplicationSpec readApplicationSpec() {
        logger.log(5, "Application: applicationSpec not set and deprecated readApplicationSpec not implemented.");
        return null;
    }

    public static String getActorDomain() {
        return AFServiceFactory.getAFServiceProperty("ActorDomainName");
    }

    public static String getApplicationName() {
        return AFServiceFactory.getAFServiceProperty("ApplicationName");
    }

    public static void setActorDomainName(String actorDomainName) {
        AFServiceFactory.addAFService("ActorDomainName", actorDomainName);
    }

    public void setApplicationName(String applicationName) {
        AFServiceFactory.addAFService("ApplicationName", applicationName);
    }

    protected void extendInitApplication() {
        logger.log(2, "Application: extendInitApplication: no values set");
    }

    protected final void readExternalValues() {
        logger.log(2, "Application: readExternalValues: no values read");
    }

    public void destroyApp() {
        logger.log(2, "Application shutdown starting.");
        this.schedulerData.setTheRouterSession(null);
        Enumeration en = this.schedulerData.getSchedulerConfig().elements();
        while (en.hasMoreElements()) {
            Scheduler scheduler = (Scheduler)en.nextElement();
            scheduler.stop();
        }
        this.schedulerData.getMySystem().clear();
        this.schedulerData.getSchedulerConfig().clear();
        this.schedulerData.setDefaultScheduler(null);
        this.schedulerData = null;
        this.container.exit();
        logger.log(2, "Application shutdown completed.");
    }

    public static Application getInstance() {
        return instance;
    }

    public void setContainerContext(Container container) {
        this.container = container;
    }

    public ApplicationSpec getApplicationSpec() {
        return this.applicationSpec;
    }

    public ActorAddress getSenderAddress() {
        return new ActorAddress("callback", "Exithandler");
    }

    protected void applicationResumed() {
        this.state = 3;
        logger.log(2, "StartApplication: Application resumed");
    }

    protected void applicationUpdated() {
        this.state = 9;
        logger.log(2, "StartApplication: Application updtated");
    }

    protected void applicationError(String reason) {
        logger.log(2, "StartApplication: Application ERROR: " + reason);
    }

    protected void applicationSuspended() {
        this.state = 5;
        logger.log(2, "StartApplication: Application suspended");
    }

    public void applictionActive() {
        this.state = 3;
        logger.log(2, "StartApplication: Application started");
    }

    public void applicationEnded() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            if (LoggerFactory.isTraceOn()) {
                logger.log(4, "InterruptedException thrown.");
            }
            e.printStackTrace();
        }
        this.getContainer().exit();
    }

    public void messageHandler(ActorMsg sig) {
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public Container getContainer() {
        return this.container;
    }

    public StateMachine getStateMachine(String id) {
        Enumeration en = this.getSchedulerData().getMySystem().keys();
        while (en.hasMoreElements()) {
            String s = (String)en.nextElement();
            if (!s.endsWith(id)) continue;
            return (StateMachine)this.getSchedulerData().getMySystem().get(s);
        }
        return null;
    }
}

